%
%---------------------------------------------------------------------  
% function [scan_range] = FT_FFT_scan_range(operating_point, range, points)
% 
% Matlab function that creates a vector of positions (tunings) for a cavity scan.
%
% operating_point (real):   center point of cavity scan range [m]
% range (real):             size of scan range [m]
% points (integer):         number of points in range
%
% scan_range (real):        vector of positions [m] between 
%                           operating_point-range/2 and operating_point+range/2
%
% Part of the SimTools package
% Andreas Freise, 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Creates a vector of positions (tunings) for a cavity scan
% Keywords: create, vector, position, scan, range

function [scan_range, scan_step] = FT_FFT_scan_range(operating_point, range, points)
  
  scan_step=range/points;
  scan_range=operating_point-range/2+(1:points)*scan_step;
  
  return;