%
%---------------------------------------------------------------------  
% function [points] = FT_FFT_required_scan_accuracy(cavity)
% 
% Matlab function to estimate the required number of steps in a full
% cavity scan to find peaks.
%
% cavity (structure):  cavity parameters and components 
%                      (see FT_init_cavity.m)
% 
% points (integer):    estimate for the number points required for a scan
%
% Part of the SimTools package
% Andreas Freise, 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Estimates the required number of steps in a full cavity scan
% Description: to find peaks
% Keywords: estimate, required, steps, peaks

function [points] = FT_FFT_required_scan_accuracy(cavity)
  
  points=ceil(cavity.F/3);
   
  return;