%
%---------------------------------------------------------------------  
% function [field] = FT_FFT_propagate(field, mygrid, lambda, distance, nr)
% 
% Matlab function performs a FFT propagation of a 2D complex 
% light field.
%
% field (complex):     2D representation of optical field
% mygrid (structure):  stores parameters of a 2D grid for FFT computations,
%                      see FT_init_grid.m
% distance (real):     distance over which the optical field should be
%                      propagated [m]
% nr (real):           index of refraction
% lambda (real):       wavelength of laser light [m]
%
% Part of the SimTools package
% Andreas Freise, Jerome Degallaix 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Performs FFT propagation of a 2D complex light field
% Keywords: propagate, propagation, 2D, field

function [field] = FT_FFT_propagate(field, mygrid, lambda, distance, nr)

  % Check the use of nr here!
  kL=-2*pi/lambda*distance*nr;
  plD=pi*lambda*distance/nr;

  %field = fftshift(fft2(field));
  %field = field .* exp(1i*kL) .* exp(1i*plD*mygrid.fft_ir_squared);
  %field = ifft2(ifftshift(field));

  field = fft2(field);
  field = field .* exp(1i*kL) .* exp(1i*plD*mygrid.fft_ir_squared);
  field = ifft2(field);
