%
%---------------------------------------------------------------------  
% function FT_FFT_plot_field(field, zoomfactor)
% 
% Simple Matlab function to plot 2D arrays of a
% light field amplitude in the x-y plane. It plots the amplitude
% with no labels nor other decorations. Useful for having a lot of 
% subplots of various input/output fields.
%
% field (complex):     2D representation of optical field
% zoomfactor (real):   zooms into the field by the given factor
%
% Part of the SimTools package
% Andreas Freise, 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Plots 2D arrays of a light field amplitude in the x-y plane
% Keywords: plot, field, 2D, amplitude

function FT_FFT_plot_field(field, zoomfactor)
  
  baseid='FFT_plot_field';
    
  [xsize,ysize]=size(field);
  
  fieldsize=min(xsize,ysize);
  
  if (zoomfactor<1)
    msgid=[baseid,':zoomfactor'];
    result=sprintf('zoomfactor must be >1');
    error(msgid,result);
  end
  
  if (zoomfactor>fieldsize)
    msgid=[baseid,':zoomfactor'];
    result=sprintf('zoomfactor must be smaller than the size of the data grid');
    error(msgid,result);
  end
    
  newxsize=round((xsize-xsize/zoomfactor)/2)+1;
  newysize=round((ysize-ysize/zoomfactor)/2)+1;
  
  plotfield=field(newxsize:xsize-newxsize+1,newysize:ysize-newysize+1);

  imagesc(abs(plotfield))
  shading interp
  map=FT_neg_colormap();
  colormap(map)
  axis tight
  set(gca, 'Xtick', []);
  set(gca, 'Ytick', []);
  axis square
  axis xy
  view([0 90])
