%
%---------------------------------------------------------------------  
% function [field] = FT_FFT_mirror(field, mirror, type)
% 
% Matlab function computes the effect of mirror on a 2D complex 
% light field (reflection and transmission).
%
% field (complex):        2D representation of optical field
% mirror (structure):     structure storing mirror parameters, see
%                         FT_init_mirror.m
% type (string):          defines which action is performed:
%                         front - reflection at front surface
%                         back - reflection at back surface
%                         trans - transmission
%
% Part of the SimTools package
% Andreas Freise, 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Computes the effect of a mirror on a 2D complex light field
% Keywords:  2D, field, mirror

function [field] = FT_FFT_mirror(field, mirror, type)

  
  baseid='FFT_mirror';

  if (~ischar(type))
    msgid=[baseid,':checkinarg'];
    result=sprintf('type can be "front", "back" or "trans".\n');
    error(msgid,result);
  end
  
  switch type
   case 'front',
     field=field .* mirror.map_refl_front .* mirror.r;
     % flip field horizontally upon reflection
     field = field(:,size(field,1):-1:1);

   case 'back',
    field=field .* mirror.map_refl_back .* mirror.r;
    % flip field horizontally upon reflection 
    field = field(:,size(field,1):-1:1);

   case 'trans',
    field=field .* mirror.map_trans .* 1i .* mirror.t;
   otherwise,
    msgid=[baseid,':checkinarg'];
    result=sprintf('type can be "front", "back" or "trans".\n');
    error(msgid,result);
  end
  
  return;