%
%---------------------------------------------------------------------  
% function [field] = FT_FFT_lens(field, mygrid, lambda, f)
% 
% Matlab function computes the effect of a lens on a 2D complex 
% light field.
%
% field (complex):     2D representation of optical field
% mygrid (structure):  stores parameters of a 2D grid for FFT computations,
%                      see FT_init_grid.m
% f (real):            focal length of lens [m]
% lambda (real):       wavelength of laser light [m]
%
% Part of the SimTools package
% Andreas Freise, Jerome Degallaix 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Computes the effect of a lens on a 2D complex light field
% Keywords: 2D, field, lens

function [field] = FT_FFT_lens(field, mygrid, lambda, f)

  k=2*pi/lambda;

  field = field .* exp(1i*k*((2*f) - sign(f)*sqrt((2*f)^2 - mygrid.r_squared))*2);

  return;