%
% ------------------------------------------------------------------
% function [q2] = FT_q_ABCD_q(M, q1, n1, n2)
%
% Function for that transforms a gaussian beam parameter
% by an ABCD matrix as follows:
% 
%                      A q1/n1 + B            (A B)
% Computes q2 = n2*  --------------- with M = (C D)
%                      C q1/n1 + D
%
%   M: 2x2 (or 2x2x2) ABCD (transformation) matrix
%   q1: input Gaussian beam parameter (complex number)
%   n1: index of refrection where beam is given by q1
%   n2: index of refrection where beam is given by q2
%
%   q2: output Gaussian beam parameter (complex number)
%
% Part of the SimTools package
% A. Freise 11.07.2006 adf@star.sr.bham.ac.uk
% ------------------------------------------------------------------
%

% Description: Transforms a Gaussian beam parameter by an ABCD matrix
% Keywords: transform, Gaussian, parameter, q

function [q2] = FT_q_ABCD_q(Min, q1, n1, n2)

  baseid='q_ABCD_q';
  
  q=q1/n1;
  
  if (length(q1)==1)
    if (size(Min,3)>1)
      M=Min(:,:,1);
    else
      M=Min;
    end
  
    q2= n2*((M(1,1)*q + M(1,2)) / ( M(2,1)*q + M(2,2)));
  else
    M=zeros(2,2,2);
    if (size(Min,3)==1)
      M(:,:,1)=Min;
      M(:,:,2)=Min;
    else
      M=Min;
    end
    q2(1)= n2*((M(1,1,1)*q(1) + M(1,2,1)) / ( M(2,1,1)*q(1) + M(2,2,1)));
    q2(1)= n2*((M(1,1,2)*q(2) + M(1,2,2)) / ( M(2,1,2)*q(2) + M(2,2,2)));
  end
  
