%
%---------------------------------------------------------------------  
% function [M] = FT_multiply_ABCDs(M1,M2)
% 
% Multiplies two ABCD matrices
%
% M,M1,M2: ABCD matrix as
%
%      ( A B )
%  M = ( C D )
%
% Andreas Freise 11.02.10 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Multiplies two ABCD matrices
% Keywords: multiply, multiplication, matrix

function [M] = FT_multiply_ABCDs(M1,M2)

  if (size(M1,3)==2 || size(M2,3)==2)
    M=zeros(2,2,2);
    if (size(M1,3)==1)
      Mtmp=M1;
      M1=M;
      M1(:,:,1)=Mtmp;
      M1(:,:,2)=Mtmp;
    end
    if (size(M2,3)==1)
      Mtmp=M2;
      M2=M;
      M2(:,:,1)=Mtmp;
      M2(:,:,2)=Mtmp;
    end
    
    M(1,1,:)=M1(1,1,:).*M2(1,1,:)+M1(1,2,:).*M2(2,1,:);
    M(1,2,:)=M1(1,1,:).*M2(1,2,:)+M1(1,2,:).*M2(2,2,:);
    M(2,1,:)=M1(2,1,:).*M2(1,1,:)+M1(2,2,:).*M2(2,1,:);
    M(2,2,:)=M1(2,1,:).*M2(1,2,:)+M1(2,2,:).*M2(2,2,:);

  else
    M(1,1)=M1(1,1)*M2(1,1)+M1(1,2)*M2(2,1);
    M(1,2)=M1(1,1)*M2(1,2)+M1(1,2)*M2(2,2);
    M(2,1)=M1(2,1)*M2(1,1)+M1(2,2)*M2(2,1);
    M(2,2)=M1(2,1)*M2(1,2)+M1(2,2)*M2(2,2);
  end

  % from finesse:
  %s.A = s1.A * s2.A + s1.B * s2.C;
  %s.B = s1.A * s2.B + s1.B * s2.D;
  %s.C = s1.C * s2.A + s1.D * s2.C;
  %s.D = s1.C * s2.B + s1.D * s2.D;
