%
%---------------------------------------------------------------------  
% function [M] = FT_invert_ABCD(M)
% 
% computes the inverse of an ABCD matrix.
%
% M: ABCD eigen matrix of the cavity (2x2x2)
%
% Andreas Freise 11.02.10 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Computes the inverse of an ABCD matrix
% Keywords: inverse, matrix, invert

function [M] = FT_invert_ABCD(M)
  
  tmp_d = M(1,1,:) .* M(2,2,:) - M(2,1,:).* M(1,2,:);
  
  M(1,1,:)=M(2,2,:);
  M(1,2,:)=-M(1,2,:);
  M(2,1,:)=-M(2,1,:);
  M(2,2,:)=M(1,1,:);
  
  for k=1:length(tmp_d)
    M(:,:,k)=M(:,:,k)./tmp_d(k);
  end

  
  % from finesse
  %tmp_d = s1.A * s1.D - s1.C * s1.B;
  %s.A = s1.D / tmp_d;
  %s.B = -s1.B / tmp_d;
  %s.C = -s1.C / tmp_d;
  %s.D = s1.A / tmp_d;
