%
%---------------------------------------------------------------------  
% function [q] = FT_cavity_ABCD_to_q(M)
% 
% computes the Gaussian beam parameter of cavity eigenmodes
% from the ABCD matrix of on optical resonantor
%
% M: ABCD eigen matrix of the cavity (2x2x2)
%
% q (comples): Gaussian beam parameter
%
% Andreas Freise 11.02.10 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Computes the Gaussian beam parameter of cavity eigenmodes
% Keywords: cavity, eigenmode, Gaussian, parameter, q

function [q] = FT_cavity_ABCD_to_q(M,n)
  
  baseid='cavity_ABCD_to_q';
  q=zeros(1,2);
  
  for k=1:2
    
    m = (M(1,1,k) + M(2,2,k)) / 2.0;
  
    if (M(1,2,k) == 0) 
      msgid=[baseid,':division by zero'];
      result=sprintf('Element B in ABCD matrix must not be zero\n');
      error(msgid,result);
    end
    q(k)=(M(2,2,k) - M(1,1,k)) / (2.0 * M(1,2,k)) -i * abs(sqrt(1.0 - m * m) / M(1,2,k));
  end
  
  q=n./q;
  
