%
%-------------------------------------------------------------------
% function [Ms] = FT_ABCD_space(L,n)
%
% Function for Matlab/Octave
% 
% Computes the ABCD Matrix for a free space propagation of
% length L as
%    
%   (1 L/n)
% M=(0  1 )
%
% Input:
%   L: length of free propagation [m]
%   n: index of refraction
% Output:
%   Ms: ABCD Matrix
%
% A. Freise 11.07.2006 adf@star.sr.bham.ac.uk
%-------------------------------------------------------------------
%

% Description: Computes the ABCD Matrix for a free space propagation of length L
% Keywords: matrix, space, propagation

function [Ms] = FT_ABCD_space(L,n)

  Ms = [ 1 L/n ; 0 1];

