%
% ------------------------------------------------------------------
% function [Mlens] = FT_ABCD_lens(f)
%
% Function for Matlab/Octave
% 
% Computes the ABCD Matrix for a thin lens of focal lengh f
% as
%    
%   (1     0 )
% M=(-1/f  1 )
%
%   f (real):       focal length [m]
%   Mlens (matrix): ABCD Matrix
%
% Part of the SimTools Package
% A. Freise 11.07.2006 afreise@googlemail.com
% ------------------------------------------------------------------
%

% Description: Computes the ABCD Matrix for a thin lens of focal lengh f
% Keywords: matrix, thin, lens

function [Mlens] = FT_ABCD_lens(f)

  Mlens = [ 1.0 0.0 ; -1.0/f 1.0];

  
