/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GConstants;
import guicomponents.GMessenger;
import guicomponents.GWinApplet;
import guicomponents.GWinData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PImage;

public class GWindow
extends Frame
implements GConstants {
    protected PApplet app;
    public GWinApplet embed;
    protected String winName;
    public GWinData data;
    protected int exitBehaviour = 3842;
    protected boolean regDraw = false;
    protected boolean regMouse = false;
    protected boolean regPre = false;
    protected boolean regKey = false;
    protected boolean regPost = false;
    protected Object preHandlerObject = null;
    protected Method preHandlerMethod = null;
    protected String preHandlerMethodName;
    protected Object drawHandlerObject = null;
    protected Method drawHandlerMethod = null;
    protected String drawHandlerMethodName;
    protected Object mouseHandlerObject = null;
    protected Method mouseHandlerMethod = null;
    protected String mouseHandlerMethodName;
    protected Object postHandlerObject = null;
    protected Method postHandlerMethod = null;
    protected String postHandlerMethodName;

    public GWindow(PApplet theApplet, String name, int x, int y, int w, int h, boolean noFrame, String mode) {
        super(name);
        this.app = theApplet;
        this.winName = name;
        if (mode == null || mode.equals("")) {
            mode = "processing.core.PGraphicsJava2D";
        }
        this.embed = new GWinApplet(mode);
        this.embed.owner = this;
        this.embed.frame = this;
        this.embed.frame.setResizable(true);
        this.embed.appWidth = w;
        this.embed.appHeight = h;
        this.windowCtorCore(x, y, w, h, noFrame, mode);
        super.setResizable(true);
    }

    public GWindow(PApplet theApplet, String name, int x, int y, PImage image, boolean noFrame, String mode) {
        super(name);
        this.app = theApplet;
        this.winName = name;
        if (mode == null || mode.equals("")) {
            mode = "processing.core.PGraphicsJava2D";
        }
        this.embed = new GWinApplet(mode);
        this.embed.owner = this;
        this.embed.frame = this;
        this.embed.frame.setResizable(true);
        this.embed.bkImage = image;
        this.embed.appWidth = image.width;
        this.embed.appHeight = image.height;
        this.windowCtorCore(x, y, image.width, image.height, noFrame, mode);
        super.setResizable(false);
    }

    private void windowCtorCore(int x, int y, int w, int h, boolean noFrame, String mode) {
        this.embed.bkColor = this.embed.color(0);
        this.embed.resize(this.embed.appWidth, this.embed.appHeight);
        this.embed.setPreferredSize(new Dimension(this.embed.appWidth, this.embed.appHeight));
        this.embed.setMinimumSize(new Dimension(this.embed.appWidth, this.embed.appHeight));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.embed), "Center");
        this.embed.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                switch (GWindow.this.exitBehaviour) {
                    case 3842: {
                        GWindow.this.removeFromG4P();
                        GWindow.this.dispose();
                        break;
                    }
                    case 3841: {
                        System.exit(0);
                    }
                }
            }
        });
        this.setUndecorated(noFrame);
        this.pack();
        this.setLocation(x, y);
        this.setVisible(true);
        this.embed.registerDraw(this.embed);
        this.regDraw = true;
        this.setOnTop(true);
        this.data = new GWinData();
        this.data.owner = this;
        G4P.addControlWindow(this);
    }

    public void add(GComponent component) {
        component.changeWindow(this.embed);
    }

    public void addData(GWinData data) {
        this.data = data;
        this.data.owner = this;
    }

    public void setOnTop(boolean onTop) {
        try {
            this.setAlwaysOnTop(onTop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void setResizable(boolean resizable) {
        if (!resizable) {
            super.setResizable(false);
        } else if (this.embed.bkImage == null) {
            super.setResizable(true);
        }
    }

    public void setBackground(PImage image) {
        this.embed.noLoop();
        this.embed.bkImage = null;
        super.setResizable(true);
        this.embed.resize(image.width, image.height);
        this.embed.bkImage = image;
        this.embed.appWidth = image.width;
        this.embed.appHeight = image.height;
        this.embed.setPreferredSize(new Dimension(this.embed.appWidth, this.embed.appHeight));
        this.embed.setMinimumSize(new Dimension(this.embed.appWidth, this.embed.appHeight));
        this.pack();
        super.setResizable(false);
        this.embed.loop();
    }

    public void setBackground(int col) {
        this.embed.bkColor = col;
    }

    public void setExitBehaviour(int exitBehaviour) {
        this.exitBehaviour = exitBehaviour;
    }

    public int getExitBehaviour() {
        return this.exitBehaviour;
    }

    private void removeFromG4P() {
        this.embed.noLoop();
        this.embed.unregisterPost(this.embed);
        if (this.regDraw) {
            this.embed.unregisterDraw(this.embed);
        }
        if (this.regPre) {
            this.embed.unregisterPre(this.embed);
        }
        if (this.regMouse) {
            this.embed.unregisterMouseEvent(this.embed);
        }
        this.regMouse = false;
        this.regPre = false;
        this.regDraw = false;
        G4P.removeControlWindow(this);
    }

    public void addDrawHandler(Object obj, String methodName) {
        try {
            this.drawHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class);
            this.drawHandlerObject = obj;
            this.drawHandlerMethodName = methodName;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{this.getClass()}});
        }
    }

    public void addPreHandler(Object obj, String methodName) {
        try {
            this.preHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class);
            this.preHandlerObject = obj;
            this.preHandlerMethodName = methodName;
            this.embed.registerPre(this.embed);
            this.regPre = true;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{this.getClass()}});
        }
    }

    public void addMouseHandler(Object obj, String methodName) {
        try {
            this.mouseHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class, MouseEvent.class);
            this.mouseHandlerObject = obj;
            this.mouseHandlerMethodName = methodName;
            this.embed.registerMouseEvent(this.embed);
            this.regMouse = true;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{this.getClass()}});
        }
    }

    public void addPostHandler(Object obj, String methodName) {
        try {
            this.postHandlerMethod = obj.getClass().getMethod(methodName, GWinApplet.class, GWinData.class);
            this.postHandlerObject = obj;
            this.postHandlerMethodName = methodName;
            this.regPost = true;
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{this.getClass()}});
        }
    }
}

