/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.Timer;
import processing.core.PApplet;

public class GTimer {
    protected PApplet app;
    protected Object eventHandlerObject = null;
    protected Method eventHandler = null;
    protected int nrepeats = -1;
    protected Timer timer = null;

    public GTimer(PApplet theApplet, Object obj, String methodName, int interval) {
        this.app = theApplet;
        this.createEventHandler(obj, methodName);
        if (this.eventHandlerObject != null) {
            this.timer = new Timer(interval, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GTimer.this.fireEvent();
                }
            });
            this.timer.stop();
        }
    }

    protected void createEventHandler(Object obj, String methodName) {
        try {
            this.eventHandler = obj.getClass().getMethod(methodName, new Class[0]);
            this.eventHandlerObject = obj;
        }
        catch (Exception e) {
            this.eventHandlerObject = null;
            System.out.println("The class " + obj.getClass().getSimpleName() + " does not have a method called " + methodName);
        }
    }

    protected void fireEvent() {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.invoke(this.eventHandlerObject, null);
                if (--this.nrepeats == 0) {
                    this.stop();
                }
            }
            catch (Exception e) {
                System.out.println("Disabling " + this.eventHandler.getName() + " due to an unknown error");
                this.eventHandler = null;
                this.eventHandlerObject = null;
            }
        }
    }

    public void start() {
        this.nrepeats = -1;
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public void start(int nrepeats) {
        this.nrepeats = nrepeats;
        if (this.timer != null) {
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public boolean isRunning() {
        if (this.timer != null) {
            return this.timer.isRunning();
        }
        return false;
    }

    public void setInterval(int msecs) {
        if (this.timer != null) {
            this.timer.setDelay(msecs);
        }
    }

    public int getInterval() {
        if (this.timer != null) {
            return this.timer.getDelay();
        }
        return -1;
    }

    public boolean isValid() {
        return this.eventHandlerObject != null && this.timer != null;
    }
}

