/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GClip;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public class GTextField
extends GComponent {
    private int cursorPos = 0;
    private int visiblePortionStart = 0;
    private int visiblePortionEnd = 0;
    private int startSelect = -1;
    private int endSelect = -1;
    private float cursorXPos = 0.0f;
    private float startSelectXPos = 0.0f;
    private float endSelectXPos = 0.0f;

    public GTextField(PApplet theApplet, String text, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.textFieldCtorCore(text, width, height);
    }

    private void textFieldCtorCore(String text, int width, int height) {
        this.width = Math.max(width, this.textWidth + 8);
        this.height = Math.max(height, this.localFont.size + 4);
        this.border = 1;
        this.setText(text);
        this.createEventHandler(this.winApp, "handleTextFieldEvents", new Class[]{GTextField.class});
        this.registerAutos_DMPK(true, true, false, true);
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
    }

    public void setFont(String fontname, int fontsize) {
        int tw = this.textWidth;
        int fs = this.localFont.size;
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
        if (fontsize != fs) {
            this.height += fontsize - fs;
        }
        this.setText(this.text);
        if (this.textWidth != tw) {
            this.width += this.textWidth - tw;
        }
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        this.adjustVisiblePortionEnd();
    }

    protected void looseFocus(GComponent toThis) {
        this.endSelect = -1;
        this.startSelect = -1;
        focusIsWith = null;
    }

    private void appendToRightOfCursor(char c) {
        this.appendToRightOfCursor("" + c);
    }

    private void appendToRightOfCursor(String s) {
        String t2;
        String t1;
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        if (this.startSelect != this.endSelect) {
            int start = Math.min(this.startSelect, this.endSelect);
            int end = Math.max(this.startSelect, this.endSelect);
            t1 = this.text.substring(0, start);
            t2 = this.text.substring(end);
            this.endSelect = this.cursorPos = start;
            this.startSelect = this.cursorPos;
        } else {
            t1 = this.text.substring(0, this.cursorPos);
            t2 = this.text.substring(this.cursorPos);
        }
        this.text = String.valueOf(t1) + s + t2;
        this.cursorPos += s.length();
        if (this.winApp.textWidth(this.text) < (float)(this.width - 12)) {
            this.visiblePortionStart = 0;
            this.visiblePortionEnd = this.text.length();
        } else if (this.cursorPos == this.text.length()) {
            this.visiblePortionEnd = this.cursorPos;
            this.adjustVisiblePortionStart();
        } else if (this.cursorPos >= this.visiblePortionEnd) {
            this.centerCursor();
        } else {
            this.adjustVisiblePortionEnd();
        }
        this.eventType = 257;
        this.fireEvent();
    }

    protected void backspaceChar() {
        if (this.startSelect != this.endSelect) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos > 0) {
            this.deleteSubstring(this.cursorPos - 1, this.cursorPos);
        }
    }

    private void deleteChar() {
        if (this.startSelect != this.endSelect) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos < this.text.length()) {
            this.deleteSubstring(this.cursorPos, this.cursorPos + 1);
        }
    }

    private void deleteSubstring(int startString, int endString) {
        int start = Math.min(startString, endString);
        int end = Math.max(startString, endString);
        this.text = String.valueOf(this.text.substring(0, start)) + this.text.substring(end);
        this.cursorPos = start;
        if (this.winApp.textWidth(this.text) < (float)(this.width - 12)) {
            this.visiblePortionStart = 0;
            this.visiblePortionEnd = this.text.length();
        } else if (this.cursorPos == this.text.length()) {
            this.visiblePortionEnd = this.cursorPos;
            this.adjustVisiblePortionStart();
        } else if (this.cursorPos <= this.visiblePortionStart) {
            this.centerCursor();
        } else {
            this.adjustVisiblePortionEnd();
        }
        this.startSelect = this.endSelect = this.cursorPos;
        this.eventType = 257;
        this.fireEvent();
    }

    private void copySubstring(int start, int end) {
        int s = Math.min(start, end);
        int e = Math.max(start, end);
        GClip.copy(this.text.substring(s, e));
    }

    private void updateXPos() {
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        int tempStart = this.startSelect;
        int tempEnd = this.endSelect;
        this.cursorXPos = this.winApp.textWidth(this.text.substring(this.visiblePortionStart, this.cursorPos));
        if (this.startSelect != this.endSelect) {
            if (this.endSelect < this.startSelect) {
                tempStart = this.endSelect;
                tempEnd = this.startSelect;
            }
            this.startSelectXPos = tempStart < this.visiblePortionStart ? 0.0f : this.winApp.textWidth(this.text.substring(this.visiblePortionStart, tempStart));
            this.endSelectXPos = tempEnd > this.visiblePortionEnd ? (float)(this.width - 12) : this.winApp.textWidth(this.text.substring(this.visiblePortionStart, tempEnd));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void adjustVisiblePortionStart() {
        block3: {
            if (!(this.winApp.textWidth(this.text.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.width - 12))) ** GOTO lbl9
            while (this.winApp.textWidth(this.text.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.width - 12)) {
                if (this.visiblePortionStart != 0) {
                    --this.visiblePortionStart;
                    continue;
                }
                break block3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                ++this.visiblePortionStart;
lbl9:
                // 2 sources

                ** while (this.winApp.textWidth((String)this.text.substring((int)this.visiblePortionStart, (int)this.visiblePortionEnd)) > (float)(this.width - 12))
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void adjustVisiblePortionEnd() {
        block4: {
            if (this.visiblePortionEnd > this.text.length()) {
                this.visiblePortionEnd = this.text.length();
            }
            if (!(this.winApp.textWidth(this.text.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.width - 12))) ** GOTO lbl11
            while (this.winApp.textWidth(this.text.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.width - 12)) {
                if (this.visiblePortionEnd != this.text.length()) {
                    ++this.visiblePortionEnd;
                    continue;
                }
                break block4;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                --this.visiblePortionEnd;
lbl11:
                // 2 sources

                ** while (this.winApp.textWidth((String)this.text.substring((int)this.visiblePortionStart, (int)this.visiblePortionEnd)) > (float)(this.width - 12))
            }
        }
    }

    private void centerCursor() {
        this.visiblePortionStart = this.visiblePortionEnd = this.cursorPos;
        while (this.winApp.textWidth(this.text.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.width - 12)) {
            if (this.visiblePortionStart != 0) {
                --this.visiblePortionStart;
            }
            if (this.visiblePortionEnd != this.text.length()) {
                ++this.visiblePortionEnd;
            }
            if (this.visiblePortionEnd == this.text.length() && this.visiblePortionStart == 0) break;
        }
    }

    private int findClosestGap(int x, boolean constrain) {
        float prev = 0.0f;
        if (constrain) {
            if (x < 0) {
                return this.visiblePortionStart;
            }
            if (x > this.width) {
                return this.visiblePortionEnd;
            }
        }
        int i = this.visiblePortionStart;
        while (i < this.text.length()) {
            float cur = this.winApp.textWidth(this.text.substring(this.visiblePortionStart, i));
            if (cur > (float)x) {
                if (cur - (float)x < (float)x - prev) {
                    return i;
                }
                return Math.max(0, i - 1);
            }
            prev = cur;
            ++i;
        }
        return this.text.length();
    }

    public void setText(String newValue) {
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        this.text = newValue;
        this.cursorPos = this.text.length();
        this.endSelect = -1;
        this.startSelect = -1;
        this.visiblePortionStart = 0;
        this.visiblePortionEnd = this.text.length();
        this.winApp.textFont(this.localFont);
        this.textWidth = (int)this.winApp.textWidth(this.text);
        if (this.textWidth > this.width - 12) {
            this.adjustVisiblePortionEnd();
        }
        this.eventType = 259;
        this.fireEvent();
    }

    public void mouseEvent(MouseEvent e) {
        if (!this.visible) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver || focusIsWith == this) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        switch (e.getID()) {
            case 501: {
                if (!this.isOver(this.winApp.mouseX, this.winApp.mouseY)) break;
                if (focusIsWith != this) {
                    this.takeFocus();
                }
                this.endSelect = this.cursorPos = this.findClosestGap(e.getX() - p.x, true);
                this.startSelect = this.cursorPos;
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.endSelect = this.cursorPos = this.findClosestGap(e.getX() - p.x, true);
                this.startSelect = this.cursorPos;
                break;
            }
            case 502: {
                break;
            }
            case 506: {
                if (focusIsWith != this) break;
                int oldEndSelect = this.endSelect;
                this.endSelect = this.cursorPos = this.findClosestGap(e.getX() - p.x, false);
                if (this.endSelect < oldEndSelect) {
                    while (this.endSelect < this.visiblePortionStart && this.visiblePortionStart > 0) {
                        --this.visiblePortionStart;
                    }
                    this.adjustVisiblePortionEnd();
                    break;
                }
                if (this.endSelect <= oldEndSelect) break;
                while (this.endSelect > this.visiblePortionEnd && this.visiblePortionEnd < this.text.length()) {
                    ++this.visiblePortionEnd;
                }
                this.adjustVisiblePortionStart();
            }
        }
        this.updateXPos();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyEvent(KeyEvent e) {
        block27: {
            block30: {
                int shortcutMask;
                block28: {
                    block34: {
                        block33: {
                            boolean shiftDown;
                            block32: {
                                block31: {
                                    block29: {
                                        if (focusIsWith != this) break block27;
                                        this.winApp.textFont(this.localFont, (float)this.localFont.size);
                                        shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                                        boolean bl = shiftDown = (e.getModifiersEx() & 0x40) == 64;
                                        if (e.getID() != 401) break block28;
                                        if (e.getKeyCode() != 35) break block29;
                                        if (shiftDown) {
                                            this.cursorPos = this.endSelect = this.text.length();
                                        } else {
                                            this.endSelect = this.cursorPos = this.text.length();
                                            this.startSelect = this.cursorPos;
                                        }
                                        this.visiblePortionEnd = this.cursorPos;
                                        if (this.cursorPos > this.visiblePortionEnd) {
                                            this.visiblePortionEnd = this.cursorPos;
                                        }
                                        this.adjustVisiblePortionStart();
                                        break block30;
                                    }
                                    if (e.getKeyCode() != 36) break block31;
                                    if (shiftDown) {
                                        this.cursorPos = this.startSelect = 0;
                                    } else {
                                        this.visiblePortionStart = 0;
                                        this.cursorPos = 0;
                                        this.endSelect = 0;
                                        this.startSelect = 0;
                                    }
                                    if (this.cursorPos < this.visiblePortionStart) {
                                        this.visiblePortionStart = this.cursorPos;
                                    }
                                    this.adjustVisiblePortionEnd();
                                    break block30;
                                }
                                if (e.getKeyCode() != 37) break block32;
                                if (shiftDown) {
                                    if (this.cursorPos > 0) {
                                        --this.cursorPos;
                                        this.endSelect = this.cursorPos;
                                    }
                                } else if (this.cursorPos > 0) {
                                    --this.cursorPos;
                                    this.startSelect = this.endSelect = this.cursorPos;
                                }
                                this.centerCursor();
                                break block30;
                            }
                            if (e.getKeyCode() != 39) break block33;
                            if (shiftDown) {
                                if (this.cursorPos < this.text.length()) {
                                    ++this.cursorPos;
                                    this.endSelect = this.cursorPos;
                                }
                            } else if (this.cursorPos < this.text.length()) {
                                ++this.cursorPos;
                                this.startSelect = this.endSelect = this.cursorPos;
                            }
                            this.centerCursor();
                            break block30;
                        }
                        if (e.getKeyCode() != 127) break block34;
                        this.deleteChar();
                        break block30;
                    }
                    if (e.getKeyCode() == 10) {
                        this.eventType = 258;
                        this.fireEvent();
                        break block30;
                    } else if ((e.getModifiers() & shortcutMask) == shortcutMask) {
                        switch (e.getKeyCode()) {
                            case 67: {
                                if (this.startSelect == this.endSelect) break;
                                this.copySubstring(this.startSelect, this.endSelect);
                                break;
                            }
                            case 86: {
                                this.appendToRightOfCursor(GClip.paste());
                                break;
                            }
                            case 88: {
                                if (this.startSelect == this.endSelect) break;
                                this.copySubstring(this.startSelect, this.endSelect);
                                this.deleteSubstring(this.startSelect, this.endSelect);
                                break;
                            }
                            case 65: {
                                this.startSelect = 0;
                                this.endSelect = this.text.length();
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block30;
                }
                if (e.getID() == 400 && (e.getModifiers() & shortcutMask) != shortcutMask) {
                    if (e.getKeyChar() == '\b') {
                        this.backspaceChar();
                    } else if (e.getKeyChar() != '\uffff' && GTextField.validUnicode(e.getKeyChar())) {
                        this.appendToRightOfCursor(e.getKeyChar());
                    }
                }
            }
            this.updateXPos();
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        this.winApp.strokeWeight((float)this.border);
        this.winApp.stroke(this.localColor.txfBorder);
        this.winApp.fill(this.localColor.txfBack);
        this.winApp.rect((float)pos.x, (float)pos.y, (float)this.width, (float)this.height);
        this.winApp.noStroke();
        if (this.startSelect != this.endSelect) {
            this.winApp.fill(this.localColor.txfSelBack);
            this.winApp.rect((float)pos.x + this.startSelectXPos + 4.0f, (float)(pos.y + 2), this.endSelectXPos - this.startSelectXPos + 1.0f, (float)(this.height - 4 + 1));
        }
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.txfFont);
        this.winApp.text(this.text.substring(this.visiblePortionStart, this.visiblePortionEnd), (float)(pos.x + 4), (float)(pos.y + (this.height - this.localFont.size) / 2 - 2), (float)(this.width - 8), (float)this.height);
        if (focusIsWith == this && this.winApp.millis() % 1000 > 500 && this.cursorPos >= this.visiblePortionStart && this.cursorPos <= this.visiblePortionEnd) {
            this.winApp.noFill();
            this.winApp.stroke(64);
            this.winApp.strokeWeight(2.0f);
            this.winApp.line((float)(pos.x + (int)this.cursorXPos + 4), (float)(pos.y + 2), (float)(pos.x + (int)this.cursorXPos + 4), (float)(pos.y + this.height - 4));
        }
        this.winApp.popStyle();
    }

    private static boolean validUnicode(char b) {
        char c = b;
        return c >= ' ' && c <= '~' || c >= '\u00a1' && c <= '\u017f' || c == '\u018f' || c == '\u0192' || c >= '\u01a0' && c <= '\u01a1' || c >= '\u01af' && c <= '\u01b0' || c >= '\u01d0' && c <= '\u01dc' || c >= '\u01fa' && c <= '\u01ff' || c >= '\u0218' && c <= '\u021b' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02b0' && c <= '\u02e9' || c >= '\u0300' && c <= '\u0345' || c >= '\u0374' && c <= '\u0375' || c == '\u037a' || c == '\u037e' || c >= '\u0384' && c <= '\u038a' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c >= '\u03da' || c >= '\u03dc' || c >= '\u03de' || c >= '\u03e0' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0486' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c9' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05c4' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f4' || c >= '\u060c' || c >= '\u061b' || c >= '\u061f' || c >= '\u0621' && c <= '\u063a' || c >= '\u0640' && c <= '\u0655' || c >= '\u0660' && c <= '\u06ee' || c >= '\u06f0' && c <= '\u06fe' || c >= '\u0901' && c <= '\u0939' || c >= '\u093c' && c <= '\u094d' || c >= '\u0950' && c <= '\u0954' || c >= '\u0958' && c <= '\u0970' || c >= '\u0e01' && c <= '\u0e3a' || c >= '\u1e80' && c <= '\u1e85' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u2000' && c <= '\u202e' || c >= '\u2030' && c <= '\u2046' || c == '\u2070' || c >= '\u2074' && c <= '\u208e' || c == '\u2091' || c >= '\u20a0' && c <= '\u20ac' || c >= '\u2100' && c <= '\u2138' || c >= '\u2153' && c <= '\u2182' || c >= '\u2190' && c <= '\u21ea' || c >= '\u2190' && c <= '\u21ea' || c >= '\u2000' && c <= '\u22f1' || c == '\u2302' || c >= '\u2320' && c <= '\u2321' || c >= '\u2460' && c <= '\u2469' || c == '\u2500' || c == '\u2502' || c == '\u250c' || c == '\u2510' || c == '\u2514' || c == '\u2518' || c == '\u251c' || c == '\u2524' || c == '\u252c' || c == '\u2534' || c == '\u253c' || c >= '\u2550' && c <= '\u256c' || c == '\u2580' || c == '\u2584' || c == '\u2588' || c == '\u258c' || c >= '\u2590' && c <= '\u2593' || c == '\u25a0' || c >= '\u25aa' && c <= '\u25ac' || c == '\u25b2' || c == '\u25ba' || c == '\u25bc' || c == '\u25c4' || c == '\u25c6' || c >= '\u25ca' && c <= '\u25cc' || c == '\u25cf' || c >= '\u25d7' && c <= '\u25d9' || c == '\u25e6' || c == '\u2605' || c == '\u260e' || c == '\u261b' || c == '\u261e' || c >= '\u263a' && c <= '\u263c' || c == '\u2640' || c == '\u2642' || c == '\u2660' || c == '\u2663' || c == '\u2665' || c == '\u2666' || c == '\u266a' || c == '\u266b' || c >= '\u2701' && c <= '\u2709' || c >= '\u270c' && c <= '\u2727' || c >= '\u2729' && c <= '\u274b' || c == '\u274d' || c >= '\u274f' && c <= '\u2752' || c == '\u2756' || c >= '\u2758' && c <= '\u275e' || c >= '\u2761' && c <= '\u2767' || c >= '\u2776' && c <= '\u2794' || c >= '\u2798' && c <= '\u27be' || c >= '\uf001' && c <= '\uf002' || c >= '\uf021' && c <= '\uf0ff' || c >= '\uf601' && c <= '\uf605' || c >= '\uf610' && c <= '\uf616' || c >= '\uf800' && c <= '\uf807' || c >= '\uf80a' && c <= '\uf80b' || c >= '\uf80e' && c <= '\uf811' || c >= '\uf814' && c <= '\uf815' || c >= '\uf81f' && c <= '\uf820' || c >= '\uf81f' && c <= '\uf820' || c == '\uf833';
    }
}

