/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import guicomponents.GFont;
import guicomponents.GMessenger;
import guicomponents.GOptionGroup;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GOption
extends GComponent {
    protected GOptionGroup ownerGroup;
    protected static PImage imgSelected;
    protected static PImage imgCleared;

    public GOption(PApplet theApplet, String text, int x, int y, int width) {
        super(theApplet, x, y);
        this.optionCtorCore(text, width, 0);
    }

    private void optionCtorCore(String text, int width, int height) {
        if (imgSelected == null) {
            imgSelected = this.winApp.loadImage("radio1.png");
        }
        if (imgCleared == null) {
            imgCleared = this.winApp.loadImage("radio0.png");
        }
        this.width = width;
        this.height = this.localFont.size + 4;
        if (height > this.height) {
            this.height = height;
        }
        this.opaque = false;
        this.setText(text);
        this.createEventHandler(this.winApp, "handleOptionEvents", new Class[]{GOption.class, GOption.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public void addEventHandler(Object obj, String methodName) {
        try {
            this.eventHandlerObject = obj;
            this.eventHandlerMethodName = methodName;
            this.eventHandlerMethod = obj.getClass().getMethod(methodName, GOption.class, GOption.class);
        }
        catch (Exception e) {
            GMessenger.message(0x1000002, this, new Object[]{methodName, new Class[]{this.getClass()}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent() {
        if (this.eventHandlerMethod != null && this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, this, this.ownerGroup.deselectedOption());
            }
            catch (Exception e) {
                GMessenger.message(-2130706429, this.eventHandlerObject, new Object[]{this.eventHandlerMethodName, e});
            }
        }
    }

    protected void calcAlignX() {
        switch (this.textAlign) {
            case 1: {
                this.alignX = GOption.imgSelected.width + 2 * this.border + 4;
                break;
            }
            case 2: {
                this.alignX = this.width - this.textWidth - 2 * this.border - 4;
                break;
            }
            case 3: {
                this.alignX = GOption.imgSelected.width + (this.width - GOption.imgSelected.width - this.textWidth) / 2;
            }
        }
    }

    public void setFont(String fontname, int fontsize) {
        int tw = this.textWidth;
        int fs = this.localFont.size;
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
        if (fontsize != fs) {
            this.height += fontsize - fs;
            this.height = Math.max(this.height, GOption.imgSelected.height);
        }
        this.setText(this.text);
        if (this.textWidth != tw) {
            this.width += this.textWidth - tw;
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        if (!this.text.equals("")) {
            if (this.border == 0) {
                this.winApp.noStroke();
            } else {
                this.winApp.stroke(this.localColor.btnBorder);
                this.winApp.strokeWeight((float)this.border);
            }
            if (this.opaque) {
                this.winApp.fill(this.localColor.txfBack);
            } else {
                this.winApp.noFill();
            }
            this.winApp.rect((float)pos.x, (float)pos.y, (float)this.width, (float)this.height);
            this.winApp.noStroke();
            this.winApp.fill(this.localColor.optFont);
            this.winApp.textFont(this.localFont, (float)this.localFont.size);
            this.winApp.text(this.text, (float)(pos.x + this.alignX), (float)(pos.y + (this.height - this.localFont.size) / 2 - 2), (float)(this.width - GOption.imgSelected.width), (float)this.height);
        }
        this.winApp.fill(this.winApp.color(255, 255));
        if (this.ownerGroup != null && this.ownerGroup.selectedOption() == this) {
            this.winApp.image(imgSelected, (float)(pos.x + 1), (float)(pos.y + (this.height - GOption.imgSelected.height) / 2));
        } else {
            this.winApp.image(imgCleared, (float)(pos.x + 1), (float)(pos.y + (this.height - GOption.imgSelected.height) / 2));
        }
        this.winApp.popStyle();
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible || this.ownerGroup == null) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.takeFocus();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.ownerGroup.setSelected(this);
                this.looseFocus(null);
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                this.eventType = 1025;
                this.fireEvent();
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                this.looseFocus(null);
            }
        }
    }

    public boolean isSelected() {
        return this.ownerGroup != null && this.ownerGroup.selectedOption() == this;
    }

    public boolean isNotSelected() {
        return this.ownerGroup == null || this.ownerGroup.selectedOption() != this;
    }

    public void setSelected(boolean selected) {
        if (this.ownerGroup != null) {
            this.ownerGroup.setSelected(this);
        }
    }

    public GOptionGroup getGroup() {
        return this.ownerGroup;
    }

    public void setGroup(GOptionGroup group) {
        this.ownerGroup = group;
    }
}

