/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.GConstants;
import guicomponents.GMessenger;
import java.io.IOException;
import java.io.InputStream;
import processing.core.PApplet;
import processing.core.PImage;

public class GCScheme
implements GConstants {
    public static final int BLUE_SCHEME = 0;
    public static final int GREEN_SCHEME = 1;
    public static final int RED_SCHEME = 2;
    public static final int PURPLE_SCHEME = 3;
    public static final int YELLOW_SCHEME = 4;
    public static final int CYAN_SCHEME = 5;
    public static final int GREY_SCHEME = 6;
    protected static PApplet app;
    protected static PImage image;
    public static final int COL_MASK = 0xFFFFFF;
    public static final int ALPHA_MASK = -16777216;
    public int schemeNo = 0;
    public int pnlFont;
    public int pnlTabBack;
    public int pnlBack;
    public int pnlBorder;
    public int btnFont;
    public int btnOff;
    public int btnOver;
    public int btnDown;
    public int btnBorder;
    public int sdrTrack;
    public int sdrThumb;
    public int sdrBorder;
    public int txfFont;
    public int txfBack;
    public int txfSelBack;
    public int txfBorder;
    public int lblFont;
    public int lblBack;
    public int lblBorder;
    public int optFont;
    public int optBack;
    public int optBorder;
    public int cbxFont;
    public int cbxBack;
    public int cbxBorder;
    public int acbBorder;
    public int acbTrack;
    public int acbFirst;
    public int acbLast;
    private int alpha = 255;

    static {
        image = null;
    }

    public static int setAlpha(int col, int alpha) {
        alpha = (alpha & 0xFF) << 24;
        col = col & 0xFFFFFF | alpha;
        return col;
    }

    public static GCScheme getColor(PApplet theApplet) {
        return GCScheme.getColor(theApplet, 0);
    }

    public static GCScheme getColor(PApplet theApplet, int schemeNo) {
        app = theApplet;
        if (image == null) {
            InputStream is = app.createInput("user_col_schema.png");
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                image = app.loadImage("user_col_schema.png");
                GMessenger.message(65794, null, null);
            } else {
                image = app.loadImage("default_col_schema.png");
            }
        }
        GCScheme scheme = new GCScheme(schemeNo);
        GCScheme.populateScheme(scheme, schemeNo);
        return scheme;
    }

    protected static void populateScheme(GCScheme s, int schemeNo) {
        schemeNo = Math.abs(schemeNo) % GCScheme.image.height;
        s.pnlFont = image.get(0, schemeNo) | 0xFF000000;
        s.pnlTabBack = image.get(1, schemeNo) | 0xFF000000;
        s.pnlBack = image.get(2, schemeNo) | 0xFF000000;
        s.pnlBorder = image.get(3, schemeNo) | 0xFF000000;
        s.btnFont = image.get(5, schemeNo) | 0xFF000000;
        s.btnOff = image.get(6, schemeNo) | 0xFF000000;
        s.btnOver = image.get(7, schemeNo) | 0xFF000000;
        s.btnDown = image.get(8, schemeNo) | 0xFF000000;
        s.sdrTrack = image.get(10, schemeNo) | 0xFF000000;
        s.sdrThumb = image.get(11, schemeNo) | 0xFF000000;
        s.sdrBorder = image.get(12, schemeNo) | 0xFF000000;
        s.txfFont = image.get(15, schemeNo) | 0xFF000000;
        s.txfBack = image.get(16, schemeNo) | 0xFF000000;
        s.txfSelBack = image.get(17, schemeNo) | 0xFF000000;
        s.txfBorder = image.get(18, schemeNo) | 0xFF000000;
        s.lblFont = image.get(20, schemeNo) | 0xFF000000;
        s.lblBack = image.get(21, schemeNo) | 0xFF000000;
        s.lblBorder = image.get(22, schemeNo) | 0xFF000000;
        s.optFont = image.get(25, schemeNo) | 0xFF000000;
        s.optBack = image.get(26, schemeNo) | 0xFF000000;
        s.optBorder = image.get(27, schemeNo) | 0xFF000000;
        s.cbxFont = image.get(30, schemeNo) | 0xFF000000;
        s.cbxBack = image.get(31, schemeNo) | 0xFF000000;
        s.cbxBorder = image.get(32, schemeNo) | 0xFF000000;
        s.acbBorder = image.get(35, schemeNo) | 0xFF000000;
        s.acbTrack = image.get(36, schemeNo) | 0xFF000000;
        s.acbLast = image.get(37, schemeNo) | 0xFF000000;
        s.acbFirst = image.get(38, schemeNo) | 0xFF000000;
    }

    public GCScheme() {
        this.schemeNo = 0;
        GCScheme.populateScheme(this, this.schemeNo);
    }

    public GCScheme(int csn) {
        this.schemeNo = csn;
        GCScheme.populateScheme(this, this.schemeNo);
    }

    public GCScheme(GCScheme gcScheme) {
        this.schemeNo = gcScheme.schemeNo;
        GCScheme.populateScheme(this, this.schemeNo);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha & 0xFF;
        int a = this.alpha << 24;
        this.pnlFont = this.pnlFont & 0xFFFFFF | a;
        this.pnlTabBack = this.pnlTabBack & 0xFFFFFF | a;
        this.pnlBack = this.pnlBack & 0xFFFFFF | a;
        this.pnlBorder = this.pnlBorder & 0xFFFFFF | a;
        this.btnFont = this.btnFont & 0xFFFFFF | a;
        this.btnOff = this.btnOff & 0xFFFFFF | a;
        this.btnOver = this.btnOver & 0xFFFFFF | a;
        this.btnDown = this.btnDown & 0xFFFFFF | a;
        this.btnBorder = this.btnBorder & 0xFFFFFF | a;
        this.sdrTrack = this.sdrTrack & 0xFFFFFF | a;
        this.sdrThumb = this.sdrThumb & 0xFFFFFF | a;
        this.sdrBorder = this.sdrBorder & 0xFFFFFF | a;
        this.txfFont = this.txfFont & 0xFFFFFF | a;
        this.txfBack = this.txfBack & 0xFFFFFF | a;
        this.txfSelBack = this.txfSelBack & 0xFFFFFF | a;
        this.txfBorder = this.txfBorder & 0xFFFFFF | a;
        this.lblFont = this.lblFont & 0xFFFFFF | a;
        this.lblBack = this.lblBack & 0xFFFFFF | a;
        this.lblBorder = this.lblBorder & 0xFFFFFF | a;
        this.optFont = this.optFont & 0xFFFFFF | a;
        this.optBack = this.optBack & 0xFFFFFF | a;
        this.optBorder = this.optBorder & 0xFFFFFF | a;
        this.cbxFont = this.cbxFont & 0xFFFFFF | a;
        this.cbxBack = this.cbxBack & 0xFFFFFF | a;
        this.cbxBorder = this.cbxBorder & 0xFFFFFF | a;
        this.acbBorder = this.acbBorder & 0xFFFFFF | a;
        this.acbTrack = this.acbTrack & 0xFFFFFF | a;
        this.acbLast = this.acbLast & 0xFFFFFF | a;
        this.acbFirst = this.acbFirst & 0xFFFFFF | a;
    }

    public int getAlpha() {
        return this.alpha;
    }
}

