/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GFont;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GButton
extends GComponent {
    public static final int OFF = 0;
    public static final int OVER = 1;
    public static final int DOWN = 2;
    protected int status;
    protected int[] col = new int[3];
    protected PImage[] bimage = new PImage[3];
    protected int btnImgWidth = 0;
    protected int imageAlign = 3;
    protected int imgAlignX;

    public GButton(PApplet theApplet, String text, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.setText(text);
        this.buttonCtorCore(width, height, null, 0);
    }

    public GButton(PApplet theApplet, String imgFile, int nbrImages, int x, int y, int width, int height) {
        super(theApplet, x, y);
        PImage img = this.winApp.loadImage(imgFile);
        if (img == null) {
            if (G4P.messages) {
                System.out.println("Can't find image file for GButton");
            }
        } else {
            this.btnImgWidth = img.width / nbrImages;
        }
        this.buttonCtorCore(width, height, img, nbrImages);
    }

    public GButton(PApplet theApplet, String text, String imgFile, int nbrImages, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.setText(text);
        PImage img = this.winApp.loadImage(imgFile);
        if (img == null) {
            if (G4P.messages) {
                System.out.println("Can't find image file for GButton");
            }
        } else {
            this.btnImgWidth = img.width / nbrImages;
        }
        this.buttonCtorCore(width, height, img, nbrImages);
    }

    private void buttonCtorCore(int width, int height, PImage img, int nbrImages) {
        this.col[0] = this.localColor.btnOff;
        this.col[1] = this.localColor.btnOver;
        this.col[2] = this.localColor.btnDown;
        this.width = Math.max(width, this.textWidth + 8);
        this.height = Math.max(height, this.localFont.size + 4);
        if (img != null) {
            this.width = Math.max(this.width, this.textWidth + this.btnImgWidth + 8);
            this.height = Math.max(this.height, this.btnImgWidth + 4);
            int i = 0;
            while (i < nbrImages) {
                this.bimage[i] = new PImage(this.btnImgWidth, img.height, 2);
                this.bimage[i].copy(img, i * this.btnImgWidth, 0, this.btnImgWidth, img.height, 0, 0, this.btnImgWidth, img.height);
                ++i;
            }
            i = nbrImages;
            while (i < 3) {
                this.bimage[i] = this.bimage[nbrImages - 1];
                ++i;
            }
        }
        this.calcAlignX();
        this.createEventHandler(this.winApp, "handleButtonEvents", new Class[]{GButton.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public void setColorScheme(int schemeNo) {
        this.localColor = GCScheme.getColor(this.winApp, schemeNo);
        this.col[0] = this.localColor.btnOff;
        this.col[1] = this.localColor.btnOver;
        this.col[2] = this.localColor.btnDown;
    }

    public void setText(String text) {
        this.text = text;
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        this.textWidth = (int)this.winApp.textWidth(text);
        this.calcAlignX();
    }

    public void setFont(String fontname, int fontsize) {
        int tw = this.textWidth;
        int fs = this.localFont.size;
        this.localFont = GFont.getFont(this.winApp, fontname, fontsize);
        if (fontsize > fs) {
            this.height += fontsize - fs;
        }
        this.setText(this.text);
        if (this.textWidth > tw) {
            this.width += this.textWidth - tw;
        }
    }

    public void setTextAlign(int align) {
    }

    public void setImageAlign(int align) {
        if (align == 1 || align == 2) {
            this.imageAlign = align;
            this.calcAlignX();
        }
    }

    protected void calcAlignX() {
        if (this.bimage[0] == null) {
            this.alignX = (this.width - this.textWidth) / 2;
        } else if (this.bimage[0] != null && this.text.length() == 0) {
            this.imageAlign = 3;
            this.imgAlignX = (this.width - this.btnImgWidth) / 2;
        } else {
            this.alignX = (this.width - this.btnImgWidth - this.textWidth) / 2;
            switch (this.imageAlign) {
                case 3: {
                    this.imageAlign = 1;
                }
                case 1: {
                    this.imgAlignX = 4;
                    this.alignX += this.btnImgWidth + 4;
                    break;
                }
                case 2: {
                    this.imgAlignX = this.width - this.btnImgWidth - 4;
                    this.alignX += 4;
                }
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        this.winApp.strokeWeight(1.0f);
        this.winApp.stroke(this.localColor.btnBorder);
        this.winApp.fill(this.col[this.status]);
        this.winApp.rect((float)pos.x, (float)pos.y, (float)this.width, (float)this.height);
        if (this.bimage[this.status] != null) {
            this.winApp.image(this.bimage[this.status], (float)(pos.x + this.imgAlignX), (float)(pos.y + (this.height - this.bimage[this.status].height) / 2));
        }
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.btnFont);
        this.winApp.textFont(this.localFont, (float)this.localFont.size);
        this.winApp.text(this.text, (float)(pos.x + this.alignX), (float)(pos.y + (this.height - this.localFont.size) / 2 - 2), (float)this.width, (float)this.height);
        this.winApp.popStyle();
    }

    public void mouseEvent(MouseEvent event) {
        if (!this.visible) {
            return;
        }
        boolean mouseOver = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (mouseOver) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (event.getID()) {
            case 501: {
                if (focusIsWith == this || !mouseOver) break;
                this.status = 2;
                this.takeFocus();
                this.eventType = 770;
                this.fireEvent();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.looseFocus(null);
                this.eventType = 769;
                this.fireEvent();
                break;
            }
            case 502: {
                if (focusIsWith != this) break;
                this.looseFocus(null);
                this.status = 0;
                this.eventType = 769;
                this.fireEvent();
                break;
            }
            case 503: {
                this.status = this.isOver(this.winApp.mouseX, this.winApp.mouseY) ? 1 : 0;
            }
        }
    }
}

