/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GTimer;
import java.awt.Point;
import processing.core.PApplet;

public class GActivityBar
extends GComponent {
    protected final int NBR_THUMBS = 4;
    protected int[] thumbX = new int[4];
    protected int[] thumbCol = new int[4];
    protected int[] thumbDeltaX = new int[4];
    protected int thumbY;
    protected int thumbDiameter;
    protected int trackHeight;
    protected GTimer timer;
    protected long duration;

    public GActivityBar(PApplet theApplet, int x, int y, int width, int height) {
        super(theApplet, x, y);
        this.height = Math.max(height, 10);
        if (this.height % 2 != 0) {
            ++this.height;
        }
        this.trackHeight = this.height - 4;
        this.width = Math.max(this.height * 4, width);
        this.initThumbPos();
        this.initThumbColor();
        this.timer = new GTimer(this.winApp, this, "update", 5);
        this.timer.stop();
        this.visible = false;
        this.registerAutos_DMPK(true, false, false, false);
    }

    private void initThumbColor() {
        this.thumbCol[0] = this.localColor.acbFirst;
        this.thumbCol[3] = this.localColor.acbLast;
        int i = 1;
        while (i < 3) {
            this.thumbCol[i] = PApplet.lerpColor((int)this.thumbCol[0], (int)this.thumbCol[3], (float)((float)i / 3.0f), (int)3);
            ++i;
        }
    }

    private void initThumbPos() {
        this.thumbX[0] = this.width / 2 + 4 * this.trackHeight / 2;
        this.thumbDeltaX[0] = 1;
        int i = 1;
        while (i < 4) {
            this.thumbX[i] = this.thumbX[i - 1] - 1 * this.trackHeight / 2;
            this.thumbDeltaX[i] = 1;
            ++i;
        }
    }

    public void start(float seconds) {
        this.duration = seconds <= 0.0f ? Long.MAX_VALUE : (long)seconds * 1000L;
        this.initThumbPos();
        this.visible = true;
        this.timer.start();
    }

    public void stop() {
        this.visible = false;
        this.timer.stop();
    }

    public void update() {
        if (this.duration > 0L) {
            this.duration -= (long)this.timer.getInterval();
            int i = 0;
            while (i < 4) {
                if (this.thumbX[i] == 0 || this.thumbX[i] == this.width) {
                    this.thumbDeltaX[i] = -this.thumbDeltaX[i];
                }
                int n = i;
                this.thumbX[n] = this.thumbX[n] + this.thumbDeltaX[i];
                ++i;
            }
        } else {
            this.visible = false;
            this.timer.stop();
        }
    }

    public void setColorScheme(int schemeNo) {
        this.localColor = GCScheme.getColor(this.winApp, schemeNo);
        this.initThumbColor();
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point pos = new Point(0, 0);
        this.calcAbsPosition(pos);
        this.winApp.ellipseMode(3);
        this.winApp.rectMode(0);
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.acbBorder);
        this.winApp.ellipse((float)pos.x, (float)(pos.y + this.height / 2), (float)this.height, (float)this.height);
        this.winApp.ellipse((float)(pos.x + this.width), (float)(pos.y + this.height / 2), (float)this.height, (float)this.height);
        this.winApp.rect((float)pos.x, (float)pos.y, (float)this.width, (float)this.height);
        this.winApp.fill(this.localColor.acbTrack);
        this.winApp.ellipse((float)pos.x, (float)(pos.y + this.height / 2), (float)this.trackHeight, (float)this.trackHeight);
        this.winApp.ellipse((float)(pos.x + this.width), (float)(pos.y + this.height / 2), (float)this.trackHeight, (float)this.trackHeight);
        this.winApp.rect((float)pos.x, (float)(pos.y + 2), (float)this.width, (float)this.trackHeight);
        int i = 3;
        while (i >= 0) {
            this.winApp.fill(this.thumbCol[i]);
            this.winApp.ellipse((float)(pos.x + this.thumbX[i]), (float)(pos.y + this.height / 2), (float)this.trackHeight, (float)this.trackHeight);
            --i;
        }
        this.winApp.popStyle();
    }
}

