/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gwoptics.graphics.Renderable;
import processing.core.PApplet;
import processing.core.PImage;

public class GWImageDistorter
extends Renderable {
    private final int _numOfThreads;
    private PImage _inImg;
    private PImage _outImg;
    private PImage _tmpImg;
    private int[] _workerRanges;
    private ArrayList<ImageWorker> _workers;
    private ThreadPoolExecutor pool;
    private ArrayBlockingQueue<Runnable> _workQueue;
    private static boolean paused = false;

    public GWImageDistorter(PApplet pApplet, int n, PImage pImage, PImage pImage2) {
        super(pApplet);
        if (n < 1) {
            throw new RuntimeException("Need to specify 1 or more threads to process the image.");
        }
        this._workers = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            this._workers.add(new ImageWorker());
            ++n2;
        }
        this._workQueue = new ArrayBlockingQueue(n);
        this.pool = new ThreadPoolExecutor(n, 100, 1000L, TimeUnit.MILLISECONDS, this._workQueue);
        if (pImage2 == null) {
            throw new RuntimeException("Output image is null");
        }
        n2 = (int)Math.floor((float)pImage2.pixels.length / (float)n);
        int n3 = (int)((float)pImage2.pixels.length % (float)n);
        this._workerRanges = new int[n];
        int n4 = 0;
        while (n4 < n) {
            if (n4 == 0) {
                this._workerRanges[n4] = n2 + n3;
                this._workers.get(n4).setOutputImage(pImage2);
                this._workers.get(n4).setStartIndex(0);
                this._workers.get(n4).setEndIndex(n2 + n3);
            } else {
                this._workerRanges[n4] = n2;
                this._workers.get(n4).setOutputImage(pImage2);
                this._workers.get(n4).setStartIndex(this._workerRanges[n4 - 1]);
                this._workers.get(n4).setEndIndex(this._workerRanges[n4] + n2);
            }
            ++n4;
        }
        this._outImg = pImage2;
        this._numOfThreads = n;
        if (pImage != null) {
            this.setImageInput(pImage);
        }
    }

    public void setImageInput(PImage pImage) {
        if (pImage != null) {
            this._inImg = pImage;
            this._tmpImg = new PImage(this._outImg.width, this._outImg.height);
            this._tmpImg.set(0, 0, pImage);
            int n = 0;
            while (n < this._workers.size()) {
                ImageWorker imageWorker = this._workers.get(n);
                imageWorker.setInputImage(this._inImg);
                ++n;
            }
        } else {
            throw new NullPointerException("Image is null");
        }
    }

    public void updateImage(float f, float f2, float f3, float f4, float f5, float f6) {
        if (!paused) {
            CountDownLatch countDownLatch = new CountDownLatch(this._numOfThreads);
            int n = 0;
            int n2 = 0;
            while (n2 < this._workers.size()) {
                ImageWorker imageWorker = this._workers.get(n2);
                imageWorker.setCountDownLatch(countDownLatch);
                n += this._workerRanges[n2];
                imageWorker.time = f;
                imageWorker.frequency = f2;
                imageWorker.h_cross_amp = f4;
                imageWorker.h_cross_phs = f6;
                imageWorker.h_plus_amp = f3;
                imageWorker.h_plus_phs = f5;
                if (!paused) {
                    this.pool.execute(imageWorker);
                }
                ++n2;
            }
            try {
                countDownLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                PApplet.println((String)interruptedException.getMessage());
                interruptedException.printStackTrace();
            }
            this._outImg.updatePixels();
        }
    }

    public void draw() {
    }

    public void pause() {
        paused = true;
    }

    public void play() {
        paused = false;
    }
}

