/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.gui.slider;

import guicomponents.GFont;
import guicomponents.GSlider;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.gwoptics.ValueType;
import org.gwoptics.graphics.Colour;
import org.gwoptics.graphics.IRenderable;
import org.gwoptics.gui.GUIException;
import processing.core.PApplet;
import processing.core.PImage;

public class gwSlider
extends GSlider
implements IRenderable {
    public String unit;
    protected PImage _leftEnd;
    protected PImage _thumb;
    protected PImage _thumb_mouseover;
    protected PImage _rightEnd;
    protected PImage _centre;
    protected String _skin;
    protected int _numTicks;
    protected int _tickLength;
    protected int _tickOffset;
    protected int _precision;
    protected boolean _renderMaxMinLabel;
    protected boolean _renderValueLabel;
    protected boolean _stickToTicks;
    protected ValueType _valueType;
    protected String[] _tickLabels;
    protected boolean _isMouseOverThumb;
    protected boolean _mousePressedOverThumb;
    protected int[] _tickPositions;
    protected float[] _tickValues;
    protected Colour _tickColour;
    protected Colour _fontColour;
    protected float init;
    protected float maxValue;
    protected float minValue;
    protected float value;

    public void setPrecision(int acc) {
        this._precision = PApplet.constrain((int)acc, (int)0, (int)6);
    }

    public void setValueType(ValueType type) {
        this._valueType = type;
    }

    public void setTickCount(int n) {
        this._numTicks = n + 1;
        this._tickLabels = null;
        this._calcTickPositions();
    }

    public void setTickLabels(String[] lbls) {
        this._tickLabels = lbls;
        this._numTicks = lbls.length - 1;
        this._calcTickPositions();
    }

    public void setStickToTicks(boolean b) {
        this._stickToTicks = b;
        if (b) {
            this._stickToTickByValue(PApplet.map((float)this.winApp.mouseX, (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue));
        }
        this._calcTickPositions();
    }

    public void setTickLength(int l) {
        this._tickLength = PApplet.constrain((int)l, (int)1, (int)10);
        this._calcControlWidthHeight();
    }

    public void setRenderMaxMinLabel(boolean value) {
        this._renderMaxMinLabel = value;
        this._calcControlWidthHeight();
    }

    public void setRenderValueLabel(boolean value) {
        this._renderValueLabel = value;
    }

    public void setTickColour(int R, int G, int B) {
        this.setTickColour(new Colour(R, G, B));
    }

    public void setTickColour(Colour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._tickColour = c;
    }

    public void setFontColour(int R, int G, int B) {
        this.setFontColour(new Colour(R, G, B));
    }

    public void setFontColour(Colour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._fontColour = c;
    }

    public void setParent(PApplet parent) {
        if (this.winApp != null) {
            throw new RuntimeException("Parent object has already been set.");
        }
        this.winApp = parent;
    }

    public int getValue() {
        return Math.round(this.value);
    }

    public float getValuef() {
        if (this._valueType == ValueType.INTEGER) {
            return Math.round(this.value);
        }
        return this.value;
    }

    public gwSlider(PApplet parent, int x, int y, int length) {
        this(parent, "gwSlider", x, y, length);
    }

    public gwSlider(PApplet parent, String skin, int x, int y, int length) {
        super(parent, x, y, length, 1);
        if (length < 1) {
            throw new RuntimeException("Length of slider must be greater than 0.");
        }
        this.createEventHandler(this.winApp, "handleSliderEvents", new Class[]{gwSlider.class});
        this._skin = skin == null ? "gwSlider" : skin;
        this._numTicks = 5;
        this._tickLength = 5;
        this._tickOffset = 3;
        this._renderMaxMinLabel = true;
        this._renderValueLabel = true;
        this._stickToTicks = false;
        this._precision = 2;
        this._valueType = ValueType.INTEGER;
        this._tickColour = new Colour(0, 0, 0);
        this._fontColour = new Colour(0, 0, 0);
        this.unit = "";
        this._leftEnd = parent.loadImage(String.valueOf(this._skin) + "/end_left.png");
        this._rightEnd = parent.loadImage(String.valueOf(this._skin) + "/end_right.png");
        this._thumb = parent.loadImage(String.valueOf(this._skin) + "/handle.png");
        this._thumb_mouseover = parent.loadImage(String.valueOf(this._skin) + "/handle_mouseover.png");
        PImage cTemp = parent.loadImage(String.valueOf(this._skin) + "/centre.png");
        String files = "";
        if (this._leftEnd == null) {
            files = String.valueOf(files) + "end_left.png\n";
        }
        if (this._rightEnd == null) {
            files = String.valueOf(files) + "end_right.png\n";
        }
        if (this._thumb == null) {
            files = String.valueOf(files) + "handle.png\n";
        }
        if (this._thumb_mouseover == null) {
            files = String.valueOf(files) + "handle_mouseover.png\n";
        }
        if (cTemp == null) {
            files = String.valueOf(files) + "centre.png\n";
        }
        if (files != "") {
            throw new GUIException("The following files could not be found for the skin " + this._skin + ": \n" + files + "\nCheck that these files are correctly placed in the data directory under a folder with" + " the same name as the skin used.\n");
        }
        if (cTemp.width != 1) {
            throw new GUIException("The supplied centre image for this skin is not of width 1px.");
        }
        if (cTemp.height != this._leftEnd.height || cTemp.height != this._rightEnd.height) {
            throw new GUIException("The image components of the slider are not all the same height.");
        }
        this.height = cTemp.height;
        int cWidth = length - this._leftEnd.width - this._rightEnd.width;
        if (cWidth < 0) {
            cWidth = 0;
        }
        this._centre = new PImage(cWidth, cTemp.height);
        cTemp.loadPixels();
        this._centre.loadPixels();
        int i = 0;
        while (i < this._centre.height) {
            int j = 0;
            while (j < this._centre.width) {
                this._centre.pixels[i * this._centre.width + j] = cTemp.pixels[i];
                ++j;
            }
            ++i;
        }
        this.thumbMin = x + this._leftEnd.width;
        this.thumbMax = x + this._leftEnd.width + this._centre.width;
        this.setLimits(50.0f, 0.0f, 100.0f);
        this.localFont = globalFont;
        this.winApp.textFont(this.localFont);
        this.winApp.textAlign(3);
        this._calcControlWidthHeight();
        this._calcTickPositions();
        this.winApp.registerKeyEvent((Object)this);
    }

    protected void _calcControlWidthHeight() {
        this.width = this._leftEnd.width + this._centre.width + this._rightEnd.width;
        this.height = this._centre.height + this._tickLength + this._tickOffset;
        if (this._renderMaxMinLabel) {
            this.height += this.localFont.size;
        }
    }

    protected void _calcTickPositions() {
        Point p = new Point();
        this.calcAbsPosition(p);
        if (this._tickLabels == null) {
            float sliderRange = this.maxValue - this.minValue;
            float dTick = sliderRange / (float)this._numTicks;
            this._tickPositions = new int[this._numTicks + 1];
            this._tickValues = new float[this._numTicks + 1];
            int i = 0;
            while (i <= this._numTicks) {
                this._tickPositions[i] = Math.round(PApplet.map((float)(this.minValue + (float)i * dTick), (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax));
                this._tickValues[i] = this.minValue + (float)i * dTick;
                ++i;
            }
        } else {
            float dTick = this._centre.width / this._numTicks;
            this._tickPositions = new int[this._numTicks + 1];
            this._tickValues = new float[this._numTicks + 1];
            int i = 0;
            while (i <= this._numTicks) {
                this._tickPositions[i] = Math.round((float)(p.x + this._leftEnd.width) + (float)i * dTick);
                this._tickValues[i] = PApplet.map((float)((float)(p.x + this._leftEnd.width) + (float)i * dTick), (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
                ++i;
            }
        }
    }

    protected void _stickToTickByValue(float v) {
        float sliderRange = this.maxValue - this.minValue;
        float dTick = sliderRange / (float)this._numTicks;
        int index = Math.round(PApplet.constrain((float)v, (float)this.minValue, (float)this.maxValue) / dTick);
        index = PApplet.constrain((int)index, (int)0, (int)(this._tickPositions.length - 1));
        this.thumbTargetPos = this._tickPositions[index];
    }

    protected void _stickToTickByPosition(float pos) {
        Point p = new Point();
        this.calcAbsPosition(p);
        float sliderRange = this.maxValue - this.minValue;
        float dTick = sliderRange / (float)this._numTicks;
        float v = PApplet.map((float)pos, (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
        int index = Math.round((v - this.minValue) / dTick);
        index = PApplet.constrain((int)index, (int)0, (int)(this._tickPositions.length - 1));
        this.thumbTargetPos = this._tickPositions[index];
    }

    public void mouseEvent(MouseEvent event) {
        float sliderRange = this.maxValue - this.minValue;
        if (this.isVisible() && sliderRange > 0.0f) {
            boolean isMouseOver = this.isOver(event.getX(), event.getY());
            switch (event.getID()) {
                case 501: {
                    if (!isMouseOver) break;
                    this.takeFocus();
                    if (this.isOverThumb(event.getX(), event.getY())) {
                        this._mousePressedOverThumb = true;
                        break;
                    }
                    this._mousePressedOverThumb = false;
                    break;
                }
                case 502: {
                    if (focusIsWith == this && isMouseOver || this._mousePressedOverThumb) {
                        if (this._stickToTicks) {
                            this._stickToTickByPosition(this.winApp.mouseX);
                        } else {
                            this.thumbTargetPos = PApplet.constrain((int)this.winApp.mouseX, (int)this.thumbMin, (int)this.thumbMax);
                        }
                        this._isMouseOverThumb = this.isOverThumb(event.getX(), event.getY());
                        this._mousePressedOverThumb = false;
                        this.eventType = 771;
                        this.fireEvent();
                        break;
                    }
                    this._isMouseOverThumb = false;
                    this._mousePressedOverThumb = false;
                    break;
                }
                case 506: {
                    if (focusIsWith != this || !this._mousePressedOverThumb) break;
                    this.thumbTargetPos = PApplet.constrain((int)this.winApp.mouseX, (int)this.thumbMin, (int)this.thumbMax);
                    break;
                }
                case 503: {
                    this._isMouseOverThumb = this.isOverThumb(event.getX(), event.getY());
                }
            }
        }
    }

    public void keyEvent(KeyEvent e) {
        if (e.getID() == 401 && this.hasFocus()) {
            if (e.getKeyCode() == 37) {
                this.thumbTargetPos = PApplet.constrain((int)(this.thumbTargetPos - 1), (int)this.thumbMin, (int)this.thumbMax);
            } else if (e.getKeyCode() == 39) {
                this.thumbTargetPos = PApplet.constrain((int)(this.thumbTargetPos + 1), (int)this.thumbMin, (int)this.thumbMax);
            }
        }
    }

    public boolean isOver(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        float val = (float)((double)this._centre.height * 0.5 - (double)this._thumb.height * 0.5);
        return ax >= p.x && ax <= p.x + this.width && (float)ay >= (float)p.y + val && (float)ay <= (float)(p.y + this.height) - val;
    }

    public boolean isOverThumb(int ax, int ay) {
        Point p = new Point(0, 0);
        this.calcAbsPosition(p);
        Rectangle r = new Rectangle((int)((double)this.thumbPos - 0.5 * (double)this._thumb.width - 1.0), (int)((double)p.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height - 1.0), this._thumb.width + 1, this._thumb.height + 1);
        return r.contains(ax, ay);
    }

    public void setLimits(int init, int min, int max) {
        this.setLimits((float)init, (float)min, (float)max);
    }

    public void setLimits(float init, float min, float max) {
        if (this._valueType != ValueType.INTEGER) {
            this.minValue = Math.min(min, max);
            this.maxValue = Math.max(min, max);
            this.init = PApplet.constrain((float)init, (float)this.minValue, (float)this.maxValue);
        } else {
            this.minValue = Math.round(Math.min(min, max));
            this.maxValue = Math.round(Math.max(min, max));
            this.init = Math.round(PApplet.constrain((float)init, (float)this.minValue, (float)this.maxValue));
        }
        this.thumbTargetPos = this.thumbPos;
        this.setValue(init, true);
    }

    public void setValue(int newValue) {
        this.setValue((float)newValue);
    }

    public void setValue(float newValue) {
        this.value = this._valueType == ValueType.INTEGER ? (float)Math.round(PApplet.constrain((float)newValue, (float)this.minValue, (float)this.maxValue)) : PApplet.constrain((float)newValue, (float)this.minValue, (float)this.maxValue);
        if (this._stickToTicks) {
            this._stickToTickByValue(newValue);
        } else {
            this.thumbTargetPos = Math.round(PApplet.map((float)this.value, (float)this.minValue, (float)this.maxValue, (float)this.thumbMin, (float)this.thumbMax));
        }
    }

    public void setValue(int newValue, boolean ignoreInteria) {
        this.setValue((float)newValue, ignoreInteria);
    }

    public void setValue(float newValue, boolean ignoreInteria) {
        this.setValue(newValue);
        if (ignoreInteria) {
            this.thumbPos = this.thumbTargetPos;
        }
    }

    public void setFont(String fontname, int fontsize) {
        this.localFont = GFont.getFont((PApplet)this.winApp, (String)fontname, (int)fontsize);
    }

    public void pre() {
        int inertia = this.thumbInertia;
        if (this.thumbPos == this.thumbTargetPos) {
            this.isValueChanging = false;
        } else {
            int change;
            while ((change = (this.thumbTargetPos - this.thumbPos) / inertia) == 0 && --inertia > 0) {
            }
            if (change != 0) {
                this.thumbPos += change;
                float newValue = 0.0f;
                if (this._stickToTicks) {
                    float tickDist = (float)this._centre.width / (float)this._numTicks;
                    float relPos = (float)((double)(this.thumbPos - this.x) - (double)this._thumb.width * 0.5);
                    int num = Math.round(relPos / tickDist);
                    newValue = this._tickValues[num];
                } else {
                    float upperVal = PApplet.map((float)(this.thumbPos + 1), (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
                    newValue = PApplet.map((float)this.thumbPos, (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
                    float lowerVal = PApplet.map((float)(this.thumbPos - 1), (float)this.thumbMin, (float)this.thumbMax, (float)this.minValue, (float)this.maxValue);
                    if (this.value > lowerVal && this.value < upperVal) {
                        newValue = this.value;
                    }
                }
                boolean valueChanged = newValue != this.value;
                this.value = newValue;
                if (valueChanged) {
                    this.eventType = 257;
                    this.fireEvent();
                }
            } else {
                this.isValueChanging = false;
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        String format = null;
        switch (this._valueType) {
            case INTEGER: {
                format = "%d%s";
                break;
            }
            case DECIMAL: {
                format = "%." + this._precision + "f%s";
                break;
            }
            case EXPONENT: {
                format = "%." + this._precision + "E%s";
            }
        }
        Point p = new Point();
        this.calcAbsPosition(p);
        this.winApp.image(this._leftEnd, (float)p.x, (float)p.y);
        this.winApp.image(this._centre, (float)(p.x + this._leftEnd.width), (float)p.y);
        this.winApp.image(this._rightEnd, (float)(p.x + this._leftEnd.width + this._centre.width), (float)p.y);
        this.winApp.pushStyle();
        this.winApp.textFont(this.localFont);
        this.winApp.textAlign(3);
        float tickDist = (float)this._centre.width / (float)this._numTicks;
        this.winApp.stroke(this._tickColour.toInt());
        this.winApp.strokeWeight(1.0f);
        this.winApp.fill(this._fontColour.toInt());
        float tickYPos = p.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.size;
        int i = 0;
        while (i < this._tickPositions.length) {
            Point pos;
            if (this._tickLabels != null) {
                pos = new Point(this._tickPositions[i], (int)tickYPos);
                this.winApp.text(this._tickLabels[i], (float)pos.x, (float)pos.y);
            } else if (i == 0 && this._renderMaxMinLabel) {
                pos = new Point(p.x + this._leftEnd.width + Math.round((float)i * tickDist), p.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.size);
                if (this._valueType == ValueType.INTEGER) {
                    this.winApp.text(String.format(format, Math.round(this.minValue), this.unit), (float)pos.x, (float)pos.y);
                } else {
                    this.winApp.text(String.format(format, Float.valueOf(this.minValue), this.unit), (float)pos.x, (float)pos.y);
                }
            } else if (i == this._numTicks && this._renderMaxMinLabel) {
                pos = new Point(p.x + this._leftEnd.width + Math.round((float)i * tickDist), p.y + this._centre.height + this._tickOffset + this._tickLength + this.localFont.size);
                if (this._valueType == ValueType.INTEGER) {
                    this.winApp.text(String.format(format, Math.round(this.maxValue), this.unit), (float)pos.x, (float)pos.y);
                } else {
                    this.winApp.text(String.format(format, Float.valueOf(this.maxValue), this.unit), (float)pos.x, (float)pos.y);
                }
            }
            this.winApp.beginShape(4);
            this.winApp.vertex((float)this._tickPositions[i], (float)(p.y + this._centre.height + this._tickOffset));
            this.winApp.vertex((float)this._tickPositions[i], (float)(p.y + this._centre.height + this._tickOffset + this._tickLength));
            this.winApp.endShape();
            this.winApp.pushStyle();
            this.winApp.stroke(230);
            this.winApp.beginShape(4);
            this.winApp.vertex((float)(this._tickPositions[i] + 1), (float)(p.y + this._centre.height + this._tickOffset));
            this.winApp.vertex((float)(this._tickPositions[i] + 1), (float)(p.y + this._centre.height + this._tickOffset + this._tickLength));
            this.winApp.endShape();
            this.winApp.popStyle();
            if (!this._isMouseOverThumb) {
                this.winApp.image(this._thumb, (float)((long)this.thumbPos - Math.round((double)this._thumb.width * 0.5) + 1L), (float)((double)p.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb.height));
            } else {
                this.winApp.image(this._thumb_mouseover, (float)((long)this.thumbPos - Math.round((double)this._thumb_mouseover.width * 0.5) + 1L), (float)((double)p.y + 0.5 * (double)this._centre.height - 0.5 * (double)this._thumb_mouseover.height));
            }
            if (this._renderValueLabel) {
                if (this._valueType == ValueType.INTEGER) {
                    this.winApp.text(String.format(format, Math.round(this.value), this.unit), (float)this.thumbPos, (float)p.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
                } else {
                    this.winApp.text(String.format(format, Float.valueOf(this.value), this.unit), (float)this.thumbPos, (float)p.y - (float)this._thumb.height * 0.5f + 0.5f * (float)this._centre.height - 4.0f);
                }
            }
            ++i;
        }
        this.winApp.popStyle();
    }
}

