/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import org.gwoptics.graphics.Colour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph3D.Axis3D;
import org.gwoptics.graphics.graph3D.IGraph3DCallback;
import org.gwoptics.graphics.graph3D.SquareGridMesh;
import processing.core.PApplet;

public class SurfaceTrace3D
extends Renderable {
    public String name;
    private SquareGridMesh _grid;
    private IColourmap _heightMap;
    private IGraph3DCallback _callback;
    private boolean _updateGrid;
    private float _dx;
    private float _dy;
    private Axis3D _ax;
    private Axis3D _az;
    private Axis3D _ay;
    private float[] _highestValue = new float[3];
    private float[] _lowestValue = new float[3];
    private boolean _autoRangeZaxis;

    public void setCallback(IGraph3DCallback cb) {
        this._callback = cb;
        this._updateGrid = true;
    }

    public void setIsSurfacedStroked(boolean b) {
        this._grid.isStroked = b;
    }

    public void setSurfaceStroke(Colour c) {
        this._grid.strokeColour = c;
    }

    public void setIsSurfaceFilled(boolean b) {
        this._grid.isFilled = b;
    }

    public void setSurfaceFill(Colour c) {
        this._grid.fillColour = c;
    }

    public void setAutoRangeZAxis(boolean value) {
        this._autoRangeZaxis = value;
    }

    public float getZValue(int X, int Y) {
        return this._grid.getZValue(X, Y);
    }

    public float[] getMaximumPoint() {
        return this._highestValue;
    }

    public float[] getLowestPoint() {
        return this._lowestValue;
    }

    public SurfaceTrace3D(PApplet parent, Axis3D x, Axis3D y, Axis3D z, int Xresolution, int Yresolution, IGraph3DCallback cb, String n, IColourmap map) {
        super(parent);
        if (cb == null) {
            throw new NullPointerException("A callback object must be specified for a trace.");
        }
        int _gridXResolution = Xresolution < 1 ? 1 : Xresolution;
        int _gridYResolution = Yresolution < 1 ? 1 : Yresolution;
        this._ax = x;
        this._ay = y;
        this._az = z;
        this.name = n;
        this._callback = cb;
        this._heightMap = map;
        this._grid = new SquareGridMesh(_gridXResolution, _gridYResolution, x.getLength() / (float)_gridXResolution, y.getLength() / (float)_gridYResolution, parent);
        if (map != null) {
            this._grid.isColoured = true;
        }
        this.calculateSpacing();
        this._updateGrid = true;
    }

    public void calculateSpacing() {
        this._dx = (this._ax.getMaxValue() - this._ax.getMinValue()) / (float)this._grid.sizeX();
        this._dy = (this._ay.getMaxValue() - this._ay.getMinValue()) / (float)this._grid.sizeY();
    }

    public void generateSurface() {
        if (this._callback != null && this._updateGrid) {
            int j;
            float val = 0.0f;
            float zMax = 0.0f;
            float zMin = 0.0f;
            float c = 0.0f;
            float d = 0.0f;
            float[][] _vals = null;
            float range = 1.0f;
            this._highestValue = new float[3];
            this._lowestValue = new float[3];
            if (this._autoRangeZaxis) {
                _vals = new float[this._grid.sizeX() + 1][this._grid.sizeY() + 1];
            } else {
                zMax = this._az.getMaxValue();
                zMin = this._az.getMinValue();
                c = this._az.getLength() / (zMax - zMin);
                d = 1.0f / (zMax - zMin);
            }
            int i = 0;
            while (i <= this._grid.sizeX()) {
                j = 0;
                while (j <= this._grid.sizeY()) {
                    val = this._callback.computePoint(this._ax.getMinValue() + (float)i * this._dx, this._ay.getMinValue() + (float)j * this._dy);
                    if (val > this._highestValue[2]) {
                        this._highestValue[0] = (float)i * this._dx;
                        this._highestValue[1] = (float)j * this._dx;
                        this._highestValue[2] = val;
                    } else if (val < this._lowestValue[2]) {
                        this._lowestValue[0] = (float)i * this._dx;
                        this._lowestValue[1] = (float)j * this._dx;
                        this._lowestValue[2] = val;
                    }
                    if (this._autoRangeZaxis) {
                        _vals[i][j] = val;
                    } else {
                        if (val < zMin) {
                            val = zMin;
                        }
                        if (val > zMax) {
                            val = zMax;
                        }
                        if (this._grid.isColoured) {
                            this._grid.setVertexColour(i, j, this._heightMap.getColourAtLocation(Math.abs((val - zMin) * d)));
                        }
                        this._grid.setZValue(i, j, (val - zMin) * c);
                    }
                    ++j;
                }
                ++i;
            }
            if (this._autoRangeZaxis) {
                zMax = this._highestValue[2];
                zMin = this._lowestValue[2];
                c = this._az.getLength() / (zMax - zMin);
                if (this._heightMap.isCentreAtZero()) {
                    range = Math.max(Math.abs(zMax), Math.abs(zMin));
                    d = 1.0f / (range * 2.0f);
                } else {
                    range = Math.abs(zMax - zMin);
                    d = 1.0f / (zMax - zMin);
                }
                this._az.setMaxValue(this._highestValue[2]);
                this._az.setMinValue(this._lowestValue[2]);
                i = 0;
                while (i <= this._grid.sizeX()) {
                    j = 0;
                    while (j <= this._grid.sizeY()) {
                        if (this._grid.isColoured) {
                            this._grid.setVertexColour(i, j, this._heightMap.getColourAtLocation(1.0f - Math.abs(_vals[i][j] - range) * d));
                        }
                        this._grid.setZValue(i, j, (_vals[i][j] - zMin) * c);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void draw() {
        this._grid.draw();
    }
}

