/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import org.gwoptics.ValueType;
import org.gwoptics.graphics.Colour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.camera.Camera3D;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PVector;

public class Axis3D
extends Renderable
implements PConstants {
    private PVector _unitVec;
    private float _length = 100.0f;
    private float _minShow = 0.0f;
    private float _maxShow = 1.0f;
    private int _axisLineWidth = 2;
    private int _axisTickLineWidth = 1;
    private static PFont _font;
    private String _label;
    private PVector _labelDirection;
    private int _majorTicks = 5;
    private int _minorTicks = 2;
    private int _majorTickSize = 10;
    private int _minorTickSize = 5;
    private int _axisTickLblSize = 8;
    private int _axisLblSize = 20;
    private PVector _axisTickLblRotation = new PVector(0.0f, 0.0f, 0.0f);
    private PVector _axisLblRotation = new PVector(0.0f, 0.0f, 0.0f);
    private float _axisLblOffset = 20.0f;
    private Colour _axisColour = new Colour(0, 0, 0);
    private Colour _fontColour = new Colour(0, 0, 0);
    private boolean _drawTicks = true;
    private boolean _drawTickLabels = true;
    private boolean _drawName = true;
    private boolean _textBillboard;
    private ValueType _tickLblType = ValueType.EXPONENT;
    private int _accuracy = 1;

    public void setAxisColour(int R, int G, int B) {
        this.setAxisColour(new Colour(R, G, B));
    }

    public void setAxisColour(Colour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._axisColour = c;
    }

    public void setFontColour(int R, int G, int B) {
        this.setFontColour(new Colour(R, G, B));
    }

    public void setFontColour(Colour c) {
        if (c == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._fontColour = c;
    }

    public void setTickLabelBillboarding(boolean value) {
        if (value) {
            if (Camera3D.getLookat() == null) {
                throw new RuntimeException("To use text billboards you must use the Camera3object in your scene.");
            }
            this._textBillboard = value;
        } else {
            this._textBillboard = false;
        }
    }

    public void setDrawTicks(boolean value) {
        this._drawTicks = value;
    }

    public void setDrawTickLabels(boolean value) {
        this._drawTickLabels = value;
    }

    public void setDrawAxisLabel(boolean value) {
        this._drawName = value;
    }

    public void setAxisLabel(String lbl) {
        this._label = lbl;
    }

    public void setLabelOffset(float val) {
        this._axisLblOffset = val;
    }

    public void setTickLabelXRotation(float val) {
        this._axisTickLblRotation.x = val;
    }

    public void setTickLabelYRotation(float val) {
        this._axisTickLblRotation.y = val;
    }

    public void setTickLabelZRotation(float val) {
        this._axisTickLblRotation.z = val;
    }

    public void setLabelXRotation(float val) {
        this._axisLblRotation.x = val;
    }

    public void setLabelYRotation(float val) {
        this._axisLblRotation.y = val;
    }

    public void setLabelZRotation(float val) {
        this._axisLblRotation.z = val;
    }

    public void setLabelDirection(PVector vlbl) {
        vlbl.normalize();
        this._labelDirection = vlbl;
    }

    public void setAxesDirection(PVector uv) {
        uv.normalize();
        this._unitVec = uv;
    }

    public void setMajorTicks(int t) {
        this._majorTicks = t;
    }

    public void setMinorTicks(int t) {
        this._minorTicks = t;
    }

    public void setTickLabelType(ValueType v) {
        this._tickLblType = v;
    }

    public void setTickLabelAccuracy(int v) {
        this._accuracy = v;
    }

    public void setMajorTickLength(int val) {
        this._majorTickSize = val;
    }

    public void setMinorTickLength(int val) {
        this._minorTickSize = val;
    }

    public void setMaxValue(float val) {
        this._maxShow = val;
    }

    public void setMinValue(float val) {
        this._minShow = val;
    }

    public void setLength(float l) {
        this._length = l;
    }

    public float getMaxValue() {
        return this._maxShow;
    }

    public float getMinValue() {
        return this._minShow;
    }

    public float getLength() {
        return this._length;
    }

    public Axis3D(PApplet parent) {
        super(parent);
        this._unitVec = new PVector(1.0f, 0.0f, 0.0f);
        if (_font == null) {
            _font = parent.loadFont("Verdana72.vlw");
        }
    }

    public void draw() {
        this._parent.pushStyle();
        this._parent.pushMatrix();
        this._parent.translate(this.position.x, this.position.y, this.position.z);
        this._parent.textAlign(3);
        this._parent.stroke(this._axisColour.toInt());
        this._parent.fill(this._fontColour.toInt());
        this._parent.strokeWeight((float)this._axisLineWidth);
        PVector length = PVector.mult((PVector)this._unitVec, (float)this._length);
        this._parent.beginShape(4);
        this._parent.vertex(0.0f, 0.0f, 0.0f);
        this._parent.vertex(length.x, length.y, length.z);
        this._parent.endShape();
        float longestLabel = 0.0f;
        PVector pos = null;
        PVector eye = null;
        PVector XZVector = null;
        float angleCamZAxis = 0.0f;
        float angleCamXZPlane = 0.0f;
        if (this._drawTicks || this._drawTickLabels) {
            PVector dvTick = PVector.div((PVector)length, (float)this._majorTicks);
            PVector dvTickMinor = PVector.div((PVector)dvTick, (float)(this._minorTicks + 1));
            PVector tickPos = new PVector(0.0f, 0.0f, 0.0f);
            PVector tickEnd = new PVector(0.0f, 0.0f, 0.0f);
            PVector tickPosMinor = new PVector(0.0f, 0.0f, 0.0f);
            PVector tickEndMinor = new PVector(0.0f, 0.0f, 0.0f);
            String tickLbl = null;
            float dValue = (this._maxShow - this._minShow) / (float)this._majorTicks;
            this._parent.strokeWeight((float)this._axisTickLineWidth);
            this._parent.textFont(_font, (float)(this._axisTickLblSize * 2));
            if (this._textBillboard) {
                eye = Camera3D.getEyeVector().get();
                eye.normalize();
                pos = Camera3D.getPosition().get();
                pos.sub(Camera3D.getLookat());
                pos.sub(this.position);
                XZVector = new PVector(pos.x, 0.0f, pos.z);
                XZVector.normalize();
                angleCamZAxis = (float)Math.atan2(pos.x, pos.z);
                angleCamXZPlane = (float)Math.acos(XZVector.dot(eye));
            }
            int i = 0;
            while (i <= this._majorTicks) {
                switch (this._tickLblType) {
                    case DECIMAL: {
                        tickLbl = String.format("%." + this._accuracy + "f", Float.valueOf(this._minShow + (float)i * dValue));
                        break;
                    }
                    case EXPONENT: {
                        tickLbl = String.format("%." + this._accuracy + "E", Float.valueOf(this._minShow + (float)i * dValue));
                        break;
                    }
                    case INTEGER: {
                        tickLbl = String.format("%d", Math.round(this._minShow + (float)i * dValue));
                    }
                }
                if ((float)tickLbl.length() > longestLabel) {
                    longestLabel = this._parent.textWidth(tickLbl);
                }
                PVector tickLblPos = PVector.add((PVector)tickPos, (PVector)PVector.mult((PVector)this._labelDirection, (float)(1.0f + this._parent.textWidth(tickLbl) / 2.0f + (float)Math.abs(this._majorTickSize))));
                tickLblPos.add(PVector.mult((PVector)this._unitVec, (float)((float)((double)this._axisTickLblSize * 1.2))));
                tickEnd = PVector.add((PVector)tickPos, (PVector)PVector.mult((PVector)this._labelDirection, (float)this._majorTickSize));
                if (this._drawTickLabels) {
                    this._parent.pushMatrix();
                    this._parent.translate(tickLblPos.x, tickLblPos.y, tickLblPos.z);
                    if (this._textBillboard) {
                        this._parent.rotateZ((float)Math.PI);
                        this._parent.rotateY(-angleCamZAxis);
                        if (Math.signum(pos.y) == 1.0f) {
                            this._parent.rotateX((float)Math.PI - angleCamXZPlane);
                        } else {
                            this._parent.rotateX((float)Math.PI + angleCamXZPlane);
                        }
                    } else {
                        this._parent.rotateZ(this._axisTickLblRotation.z);
                        this._parent.rotateX(this._axisTickLblRotation.x);
                        this._parent.rotateY(this._axisTickLblRotation.y);
                    }
                    this._parent.text(tickLbl, 0.0f, 0.25f * (float)Axis3D._font.size, 0.0f);
                    this._parent.popMatrix();
                }
                if (this._drawTicks) {
                    this._parent.beginShape(4);
                    this._parent.vertex(tickPos.x, tickPos.y, tickPos.z);
                    this._parent.vertex(tickEnd.x, tickEnd.y, tickEnd.z);
                    this._parent.endShape();
                    if (i != 0) {
                        tickPosMinor = tickPos.get();
                        int j = 0;
                        while (j < this._minorTicks) {
                            tickPosMinor = PVector.sub((PVector)tickPosMinor, (PVector)dvTickMinor);
                            tickEndMinor = PVector.add((PVector)tickPosMinor, (PVector)PVector.mult((PVector)this._labelDirection, (float)this._minorTickSize));
                            this._parent.beginShape(4);
                            this._parent.vertex(tickPosMinor.x, tickPosMinor.y, tickPosMinor.z);
                            this._parent.vertex(tickEndMinor.x, tickEndMinor.y, tickEndMinor.z);
                            this._parent.endShape();
                            ++j;
                        }
                    }
                }
                tickPos.add(dvTick);
                ++i;
            }
            this._parent.popMatrix();
        }
        if (this._drawName) {
            this._parent.textFont(_font, (float)this._axisLblSize);
            PVector lblPos = PVector.add((PVector)this.position, (PVector)PVector.div((PVector)length, (float)2.0f));
            lblPos.add(PVector.mult((PVector)this._labelDirection, (float)(longestLabel + (float)this._axisLblSize + this._axisLblOffset)));
            this._parent.pushMatrix();
            this._parent.translate(lblPos.x, lblPos.y, lblPos.z);
            this._parent.rotateZ(this._axisLblRotation.z);
            this._parent.rotateX(this._axisLblRotation.x);
            this._parent.rotateY(this._axisLblRotation.y);
            this._parent.text(String.valueOf(this._label), 0.0f, 0.25f * (float)Axis3D._font.size, 0.0f);
            this._parent.popMatrix();
        }
        this._parent.popStyle();
    }
}

