/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;
import org.gwoptics.graphics.graph2D.traces.Line2DTrace;
import org.gwoptics.graphics.graph2D.traces.Trace2DException;
import processing.core.PApplet;

public class RollingLine2DTrace
extends Line2DTrace {
    protected int _drawPoint;
    protected ReentrantLock _lock;
    protected boolean _doDraw;
    protected Timer _timer;
    protected long _refreshRate;
    protected boolean _isMaster;
    protected RollingLine2DTrace[] _slaveTraces;

    public long getRefreshRate() {
        return this._refreshRate;
    }

    protected boolean isMaster() {
        return this._isMaster;
    }

    public RollingLine2DTrace(ILine2DEquation eq, long RefreshRate) {
        super(eq);
        this._refreshRate = RefreshRate;
        this._timer = new Timer();
        this._isMaster = true;
        this._lock = new ReentrantLock();
        this._drawPoint = 0;
        this._drawPoint = Integer.MAX_VALUE;
        this._slaveTraces = new RollingLine2DTrace[0];
    }

    public void setParent(PApplet parent) {
        super.setParent(parent);
        parent.registerPre((Object)this);
    }

    public void setGraph(IGraph2D grph) {
        super.setGraph(grph);
        this._drawPoint = PApplet.constrain((int)this._drawPoint, (int)0, (int)(this._pointData.length - 1));
    }

    public void onAddTrace(Object[] traces) {
        if (traces != null && traces.length > 0) {
            Object[] objectArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                Object t = objectArray[n2];
                if (t instanceof RollingLine2DTrace) {
                    this._isMaster = false;
                    RollingLine2DTrace rt = (RollingLine2DTrace)t;
                    if (rt.isMaster()) {
                        rt._addTraceToMaster(this);
                    }
                    if (rt.getRefreshRate() != this._refreshRate) {
                        throw new Trace2DException("The refresh rate of this trace must be the same as the refresh rate of the Rolling2DTraces already present in the Graph2D object.");
                    }
                } else {
                    throw new Trace2DException("There are other types of traces that are not Rolling2DTraces, remove before using a Rolling2DTrace.");
                }
                ++n2;
            }
        }
        if (this._isMaster) {
            this._slaveTraces = new RollingLine2DTrace[0];
            this._timer.schedule((TimerTask)new RollingTick(), this._refreshRate);
        } else if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    public void onRemoveTrace() {
        if (this._isMaster && this._slaveTraces != null && this._slaveTraces.length > 0) {
            RollingLine2DTrace._changeMasterTrace(this, this._slaveTraces[0]);
        }
    }

    protected static void _changeMasterTrace(RollingLine2DTrace prev, RollingLine2DTrace next) {
        if (prev.isMaster() && !next.isMaster()) {
            try {
                prev._lock.lock();
                next._lock.lock();
                prev._removeTraceFromMaster(next);
                prev._isMaster = false;
                next._isMaster = true;
                next._slaveTraces = prev._slaveTraces;
                next._timer = new Timer();
                next._timer.schedule((TimerTask)next.new RollingTick(), next._refreshRate);
            }
            finally {
                prev._lock.unlock();
                next._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _addTraceToMaster(RollingLine2DTrace rolling2DTrace) {
        if (!this._isMaster || rolling2DTrace == null) return;
        RollingLine2DTrace[] rollingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            RollingLine2DTrace[] tmp = new RollingLine2DTrace[this._slaveTraces.length + 1];
            System.arraycopy(this._slaveTraces, 0, tmp, 0, this._slaveTraces.length);
            tmp[tmp.length - 1] = rolling2DTrace;
            this._slaveTraces = new RollingLine2DTrace[tmp.length];
            System.arraycopy(tmp, 0, this._slaveTraces, 0, tmp.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _removeTraceFromMaster(RollingLine2DTrace t) {
        if (!this._isMaster || t == null) return;
        RollingLine2DTrace[] rollingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            RollingLine2DTrace[] tmp = new RollingLine2DTrace[this._slaveTraces.length];
            int ix = 0;
            RollingLine2DTrace[] rollingLine2DTraceArray2 = this._slaveTraces;
            int n = this._slaveTraces.length;
            int n2 = 0;
            while (n2 < n) {
                RollingLine2DTrace rt = rollingLine2DTraceArray2[n2];
                if (!t.equals(rt)) {
                    tmp[ix] = rt;
                    ++ix;
                }
                ++n2;
            }
            if (tmp[this._slaveTraces.length - 1] != null) return;
            this._slaveTraces = new RollingLine2DTrace[tmp.length - 1];
            int i = 0;
            while (i < tmp.length - 1) {
                this._slaveTraces[i] = tmp[i];
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void generate() {
        if (this._ax == null || this._ay == null) {
            throw new RuntimeException("One of the axis objects are null, set them using setAxes().");
        }
        int i = 0;
        while (i < this._pointData.length) {
            if (i < this._drawPoint) {
                this._eqData[i] = this._eqData[i + 1];
                this._pointData[i] = this._pointData[i + 1];
            } else if (i == this._drawPoint) {
                this._eqData[i] = this._cb.computePoint(this._drawPoint, i);
                this._pointData[i] = this._ay.valueToPosition((float)this._eqData[i]);
            } else if (i > this._drawPoint) {
                this._eqData[i] = Double.NaN;
                this._pointData[i] = Float.NaN;
            }
            ++i;
        }
    }

    public void pre() {
        try {
            this._lock.lock();
            if (this._isMaster && this._doDraw) {
                this.generate();
                RollingLine2DTrace[] rollingLine2DTraceArray = this._slaveTraces;
                int n = this._slaveTraces.length;
                int n2 = 0;
                while (n2 < n) {
                    RollingLine2DTrace t = rollingLine2DTraceArray[n2];
                    if (t != null) {
                        t.generate();
                    }
                    ++n2;
                }
                this._doDraw = false;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void draw() {
        if (this._ax != null) {
            this._ax.setDrawTickLabels(false);
            this._ax.setDrawTicks(false);
            this._ax.setAxisLabel("Time");
        }
        super.draw();
    }

    protected class RollingTick
    extends TimerTask {
        protected RollingTick() {
        }

        public void run() {
            if (RollingLine2DTrace.this._isMaster) {
                try {
                    RollingLine2DTrace.this._lock.lock();
                    RollingLine2DTrace.this._doDraw = true;
                    RollingLine2DTrace.this._timer.schedule((TimerTask)new RollingTick(), RollingLine2DTrace.this._refreshRate);
                }
                finally {
                    RollingLine2DTrace.this._lock.unlock();
                }
            }
        }
    }
}

