/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import org.gwoptics.graphics.Colour;
import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.backgrounds.IGraph2DBackground;
import org.gwoptics.graphics.graph2D.effects.ITraceColourEffect;
import org.gwoptics.graphics.graph2D.traces.IGraphTrace;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;
import processing.core.PApplet;
import processing.core.PVector;

public class Line2DTrace
implements IGraphTrace {
    protected Axis2D _ax;
    protected Axis2D _ay;
    protected IGraph2DBackground _back;
    protected PApplet _parent;
    protected ILine2DEquation _cb;
    protected double[] _eqData;
    protected float[] _pointData;
    protected boolean _yAutoRange;
    protected PVector _pos;
    protected Colour _traceColour;
    protected ITraceColourEffect _effect;

    public Line2DTrace(ILine2DEquation eq) {
        this._cb = eq;
        this._pos = new PVector(0.0f, 0.0f);
        this._traceColour = new Colour(0, 0, 0);
    }

    public void setGraph(IGraph2D grp) {
        this._ax = grp.getXAxis();
        this._ay = grp.getYAxis();
        this._setupTraceEffect();
        this._back = grp.getGraphBackground();
        this._pointData = new float[this._ax.getLength()];
        this._eqData = new double[this._ax.getLength()];
    }

    public void setParent(PApplet parent) {
        if (parent == null) {
            throw new NullPointerException("Parent object can not be null");
        }
        this._parent = parent;
    }

    public void setPosition(int x, int y) {
        this._pos.x = x;
        this._pos.y = y;
    }

    public void setEquationCallback(ILine2DEquation equation) {
        this._cb = equation;
    }

    public void generate() {
        if (this._ax == null || this._ay == null) {
            throw new RuntimeException("One of the axis objects are null, set them using setAxes().");
        }
        if (this._cb != null) {
            float dRes = (this._ax.getMaxValue() - this._ax.getMinValue()) / (float)(this._ax.getLength() - 1);
            double highestValue = 0.0;
            double lowestValue = 0.0;
            int i = 0;
            while (i < this._eqData.length) {
                double val;
                this._eqData[i] = val = this._cb.computePoint(this._ax.getMinValue() + (float)i * dRes, i);
                if (this._yAutoRange) {
                    if (val > highestValue) {
                        highestValue = val;
                    } else if (val < lowestValue) {
                        val = lowestValue;
                    }
                } else {
                    this._pointData[i] = this._ay.valueToPosition((float)val);
                }
                ++i;
            }
            if (this._yAutoRange) {
                this._ay.setMinValue((float)lowestValue);
                this._ay.setMaxValue((float)highestValue);
                i = 0;
                while (i < this._eqData.length) {
                    this._pointData[i] = this._ay.valueToPosition((float)this._eqData[i]);
                    ++i;
                }
            }
        }
    }

    public void draw() {
        if (this._parent == null) {
            throw new NullPointerException("Set parent object before plotting.");
        }
        float dRes = (this._ax.getMaxValue() - this._ax.getMinValue()) / (float)(this._ax.getLength() - 1);
        this._parent.pushMatrix();
        this._parent.pushStyle();
        this._parent.translate(this._pos.x, this._pos.y);
        int i = 1;
        while (i < this._pointData.length) {
            boolean b1 = true;
            boolean b2 = true;
            float y1 = this._pointData[i - 1];
            float y2 = this._pointData[i];
            if (!Float.isNaN(y1) && !Float.isNaN(y2)) {
                if (y1 > (float)this._ay.getLength()) {
                    y1 = this._ay.getLength();
                } else if (y1 < 0.0f) {
                    y1 = 0.0f;
                } else {
                    b1 = false;
                }
                if (y2 > (float)this._ay.getLength()) {
                    y2 = this._ay.getLength();
                } else if (y2 < 0.0f) {
                    y2 = 0.0f;
                } else {
                    b2 = false;
                }
                if (!b1 || !b2) {
                    Colour cTrace = this._effect != null ? this._effect.getPixelColour(i - 1, (int)y1, this._ax.getMinValue() + (float)i * dRes, (float)this._eqData[i - 1]) : this._traceColour;
                    this._parent.stroke(cTrace.R * 255.0f, cTrace.G * 255.0f, cTrace.B * 255.0f, cTrace.A * 255.0f);
                    this._parent.strokeWeight(1.0f);
                    this._parent.line((float)(i - 1), -y1, (float)i, -y2);
                }
            }
            ++i;
        }
        this._parent.popStyle();
        this._parent.popMatrix();
    }

    public void setTraceColour(int R, int G, int B) {
        this._traceColour = new Colour(R, G, B);
    }

    public void removeEffect() {
        this._effect = null;
    }

    public void setTraceEffect(ITraceColourEffect effect) {
        this._effect = effect;
        this._setupTraceEffect();
    }

    private void _setupTraceEffect() {
        if (this._ax != null && this._ay != null && this._effect != null) {
            this._effect.setXAxisValues(this._ax.getLength(), this._ax.getMinValue(), this._ax.getMaxValue());
            this._effect.setYAxisValues(this._ay.getLength(), this._ay.getMinValue(), this._ay.getMaxValue());
        }
    }

    public void onAddTrace(Object[] traces) {
    }

    public void onRemoveTrace() {
    }
}

