/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.effects;

import org.gwoptics.graphics.Colour;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph2D.effects.AxisColourmapEffect;

public class YAxisColourmapEffect
extends AxisColourmapEffect {
    public YAxisColourmapEffect(IColourmap map) {
        super(map);
    }

    public Colour getPixelColour(int pos, int pos2, float xVal, float yVal) {
        if (!this._xaxisDataSet || !this._yaxisDataSet) {
            throw new RuntimeException("Axis data has not been set. Set using setXAxisValues and setYAxisValues before using.");
        }
        if (this._map.isCentreAtZero()) {
            if (this.yContainsZero) {
                float range = Math.max(Math.abs(this.yMax), Math.abs(this.yMin));
                return this._map.getColourAtLocation(1.0f - Math.abs(yVal - range) / (range * 2.0f));
            }
            float range = this.yMax - this.yMin;
            if (Math.signum(range) == 1.0f) {
                return this._map.getColourAtLocation(0.5f + (float)((double)(yVal - this.yMin) * 0.5 / (double)range));
            }
            if (Math.signum(range) == -1.0f) {
                return this._map.getColourAtLocation((float)((double)(yVal - this.yMin) * 0.5 / (double)range));
            }
        } else {
            return this._map.getColourAtLocation(Math.abs((yVal - this.yMin) / (this.yMax - this.yMin)));
        }
        return new Colour(0, 0, 0);
    }
}

