/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.backgrounds;

import org.gwoptics.graphics.Colour;
import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.backgrounds.IGraph2DBackground;
import processing.core.PApplet;

public class SolidColourBackground
implements IGraph2DBackground {
    protected Axis2D _ax;
    protected Axis2D _ay;
    protected int _width;
    protected int _height;
    protected PApplet _parent;
    protected Colour _background;

    public void setBackgroundColour(int R, int G, int B) {
        this._background = new Colour(R, G, B);
    }

    public void setNoBackground() {
        this._background = null;
    }

    public SolidColourBackground(Colour bk) {
        this._background = bk;
    }

    public void setAxes(Axis2D x, Axis2D y) {
        this._ax = x;
        this._ay = y;
    }

    public void setDimensions(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public void setParent(PApplet parent) {
        if (this._parent != null) {
            throw new RuntimeException("Parent object has already been set");
        }
        this._parent = parent;
    }

    public void draw() {
        if (this._background != null && this._parent != null) {
            this._parent.pushStyle();
            this._parent.pushMatrix();
            this._parent.translate(0.0f, (float)(-this._height / 2));
            this._parent.fill(this._background.toInt());
            this._parent.noStroke();
            this._parent.rect(0.0f, 0.0f, (float)this._height, (float)this._width);
            this._parent.popStyle();
            this._parent.popMatrix();
        }
    }
}

