/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.gaussbeams;

import org.gwoptics.mathutils.Complex;
import org.gwoptics.mathutils.MathUtils;

public class GaussMode {
    double _lambda;
    double _nr;
    public Complex _qx;
    public Complex _qy;

    public GaussMode() {
        this._lambda = 1.064E-6;
        this._nr = 1.0;
        this._qx = GaussMode.make_q(0.001, 0.0, this._lambda, this._nr);
        this._qy = GaussMode.make_q(0.001, 0.0, this._lambda, this._nr);
    }

    public GaussMode(float lambda, Complex q, float nr) {
        assert (this._lambda > 0.0);
        assert (q.imag() > 0.0);
        this._lambda = lambda;
        this._qx = q;
        this._qy = q;
        this._nr = nr;
    }

    public GaussMode(float lambda, Complex qx, Complex qy, float nr) {
        assert (this._lambda > 0.0);
        assert (qx.imag() > 0.0);
        assert (qy.imag() > 0.0);
        this._lambda = lambda;
        this._qx = qx;
        this._qy = qy;
        this._nr = nr;
    }

    public GaussMode(float lambda, float w0, float z, float nr) {
        assert (this._lambda > 0.0);
        assert (w0 > 0.0f);
        this._lambda = lambda;
        this._nr = nr;
        this._qy = this._qx = GaussMode.make_q(w0, z, this._lambda, this._nr);
    }

    public GaussMode(float lambda, float w0x, float zx, float w0y, float zy, float nr) {
        assert (this._lambda > 0.0);
        assert (w0x > 0.0f);
        assert (w0y > 0.0f);
        this._lambda = lambda;
        this._nr = nr;
        this._qx = GaussMode.make_q(w0x, zx, this._lambda, this._nr);
        this._qy = GaussMode.make_q(w0y, zy, this._lambda, this._nr);
    }

    public double get_lambda() {
        return this._lambda;
    }

    public double get_nr() {
        return this._nr;
    }

    public Complex get_qx() {
        return this._qx;
    }

    public Complex get_qy() {
        return this._qy;
    }

    public double get_w0x() {
        return this.w0_size(this._qx);
    }

    public double get_w0y() {
        return this.w0_size(this._qy);
    }

    public double get_wx() {
        return this.w_size(this._qx);
    }

    public double get_wy() {
        return this.w_size(this._qy);
    }

    public double get_zx() {
        return this._qx.real();
    }

    public double get_zy() {
        return this._qy.real();
    }

    public double get_zrx() {
        return this._qx.imag();
    }

    public double get_zry() {
        return this._qy.imag();
    }

    public double get_ROCx() {
        return GaussMode.ROC(this._qx);
    }

    public double get_ROCy() {
        return GaussMode.ROC(this._qy);
    }

    public double get_Gouyx() {
        return GaussMode.Gouy(this._qx);
    }

    public double get_Gouyy() {
        return GaussMode.Gouy(this._qy);
    }

    public Complex get_q0x() {
        return GaussMode.q0(this._qx);
    }

    public Complex get_q0y() {
        return GaussMode.q0(this._qy);
    }

    public static Complex make_q(double w0, double z, double lambda, double nr) {
        Complex q = new Complex(0.0);
        q.setReal(z);
        q.setImag(w0 * w0 * Math.PI / lambda * nr);
        return q;
    }

    public Double w0_size(Complex q) {
        return Math.sqrt(q.imag() / Math.PI) * Math.sqrt(this._lambda / this._nr);
    }

    public static Double w0_size(Complex q, Double lambda, Double nr) {
        assert (nr > 0.0);
        assert (lambda > 0.0);
        return Math.sqrt(q.imag() / Math.PI) * Math.sqrt(lambda / nr);
    }

    public Double w_size(Complex q) {
        assert (q.imag() > 0.0);
        return Complex.modulus(q) / Math.sqrt(Math.PI * q.imag()) * Math.sqrt(this._lambda / this._nr);
    }

    public static Double w_size(Complex q, Double lambda, Double nr) {
        assert (nr > 0.0);
        assert (lambda > 0.0);
        assert (q.imag() > 0.0);
        return Complex.modulus(q) / Math.sqrt(Math.PI * q.imag()) * Math.sqrt(lambda / nr);
    }

    public static Double ROC(Complex q) {
        return Complex.absSquared(q) / Complex.real(q);
    }

    public static Double Gouy(Complex q) {
        assert (q.imag() > 0.0);
        return Complex.real(q) / Complex.imag(q);
    }

    public static Complex q0(Complex q) {
        Complex temp_q = q;
        temp_q.setReal(0.0);
        return temp_q;
    }

    public static Double zr(Complex q) {
        return q.imag();
    }

    public Complex u_nm(int n, int m, double x, double y) {
        Complex temp_u = Complex.multiply(this.u_n(n, this._qx, x), this.u_n(m, this._qy, y));
        return temp_u;
    }

    public double u_nm_amp(int n, int m, double x, double y) {
        double temp_u = this.u_n_amp(n, this._qx, x) * this.u_n_amp(m, this._qy, y);
        return temp_u;
    }

    public double u_nm_phs(int n, int m, double x, double y) {
        double temp_u = this.u_n_phs(n, this._qx, x) + this.u_n_phs(m, this._qy, y);
        return temp_u;
    }

    public double u_n_amp(int n, Complex q, double x) {
        assert (n >= 0);
        assert (q.imag() > 0.0);
        Double w = GaussMode.w_size(q, this._lambda, this._nr);
        Double a1 = 0.8932438417380023;
        Double factor = a1 / Math.sqrt(Math.pow(2.0, n) * (double)MathUtils.factorial(n) * w) * MathUtils.hermite(n, Math.sqrt(2.0) * x / GaussMode.w_size(q, this._lambda, this._nr));
        factor = factor * Math.exp(-1.0 * x * x / (w * w));
        return factor;
    }

    public double u_n_phs(int n, Complex q, double x) {
        assert (n >= 0);
        assert (q.imag() > 0.0);
        Double ROC = GaussMode.ROC(q);
        Double Psi = GaussMode.Gouy(q);
        Double k = Math.PI * 2 / this._lambda * this._nr;
        Double phase = ((double)n + 0.5) * Psi;
        phase = phase - k * Math.pow(x, 2.0) / (2.0 * ROC);
        return phase;
    }

    public Complex u_n(int n, Complex q, double x) {
        assert (n >= 0);
        assert (q.imag() > 0.0);
        Double a1 = 0.8932438417380023;
        Double k = Math.PI * 2 / this._lambda * this._nr;
        Double factor = a1 / Math.sqrt(Math.pow(2.0, n) * (double)MathUtils.factorial(n) * GaussMode.w0_size(q, this._lambda, this._nr)) * MathUtils.hermite(n, Math.sqrt(2.0) * x / GaussMode.w_size(q, this._lambda, this._nr));
        Complex z1 = Complex.sqrt(Complex.divide(GaussMode.q0(q), q));
        Complex z2 = Complex.sqrt(Complex.divide(Complex.multiply(GaussMode.q0(q), Complex.conj(q)), Complex.multiply(Complex.conj(GaussMode.q0(q)), q)));
        Complex z3 = Complex.multiply(z1, Complex.pow(z2, n, 1));
        Complex phase = Complex.scale(-1.0 * k * x * x / 2.0, Complex.inv(q));
        factor = factor * Math.exp(-1.0 * phase.imag());
        Complex z4 = Complex.scaleAndDelay(factor, phase.real(), z3);
        return z4;
    }

    public Complex u_pl_xy(int p, int l, double x, double y) {
        Double r = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        Double phi = Math.atan2(x, y);
        return this.u_pl(p, l, r, phi);
    }

    public Complex u_pl(int p, int l, double r, double phi) {
        int l_abs = Math.abs(l);
        if (l_abs < 0 || p < l_abs) {
            throw new RuntimeException("LG mode index error (0<|l|<p)");
        }
        Complex q = this._qx;
        Double k = Math.PI * 2 / this._lambda * this._nr;
        Double w = GaussMode.w_size(q, this._lambda, this._nr);
        Double sr = Math.sqrt(2.0) * r / w;
        Double psi = GaussMode.Gouy(q);
        Double q_abs = Complex.absSquared(q);
        Double expFactor = -0.5 * k * r * r;
        Double factor = Math.sqrt((double)(2L * MathUtils.factorial(p)) / (Math.PI * (double)MathUtils.factorial(l_abs + p))) / w;
        Double Gouyphase = (double)(2 * p + l_abs + 1) * psi;
        Double AmpPattern = Math.exp(expFactor * q.imag() / q_abs) * Math.pow(sr, l_abs) * MathUtils.laguerre(p, l_abs, sr * sr);
        Double Spiral = (double)l * phi;
        Double Sphere = expFactor * q.real() / q_abs;
        return Complex.newAbsPhi(factor * AmpPattern, Gouyphase + Sphere + Spiral);
    }

    public double u_pl_amp_xy(int p, int l, double x, double y) {
        Double r = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        Double phi = Math.atan2(x, y);
        return this.u_pl_amp(p, l, r, phi);
    }

    public double u_pl_amp(int p, int l, double r, double phi) {
        int l_abs = Math.abs(l);
        if (l_abs < 0 || p < l_abs) {
            throw new RuntimeException("LG mode index error (0<|l|<p)");
        }
        Complex q = this._qx;
        Double k = Math.PI * 2 / this._lambda * this._nr;
        Double w = GaussMode.w_size(q, this._lambda, this._nr);
        Double sr = Math.sqrt(2.0) * r / w;
        Double q_abs = Complex.absSquared(q);
        Double expFactor = -0.5 * k * r * r;
        Double factor = Math.sqrt((double)(2L * MathUtils.factorial(p)) / (Math.PI * (double)MathUtils.factorial(l_abs + p))) / w;
        Double AmpPattern = Math.exp(expFactor * q.imag() / q_abs) * Math.pow(sr, l_abs) * MathUtils.laguerre(p, l_abs, sr * sr);
        return factor * AmpPattern;
    }

    public Complex u_lp_cos_xy(int p, int l, double x, double y) {
        Double r = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        Double phi = Math.atan2(x, y);
        return this.u_pl_cos(p, l, r, phi);
    }

    public Complex u_pl_cos(int p, int l, double r, double phi) {
        int l_abs = Math.abs(l);
        if (l_abs < 0 || p < l_abs) {
            throw new RuntimeException("LG mode index error (0<|l|<p)");
        }
        Complex q = this._qx;
        Double k = Math.PI * 2 / this._lambda * this._nr;
        Double w = GaussMode.w_size(q, this._lambda, this._nr);
        Double sr = Math.sqrt(2.0) * r / w;
        Double psi = GaussMode.Gouy(q);
        Double q_abs = Complex.absSquared(q);
        Double expFactor = -0.5 * k * r * r;
        Double factor = Math.sqrt((double)(2L * MathUtils.factorial(p)) / (Math.PI * (double)MathUtils.factorial(l_abs + p))) / w;
        Double Gouyphase = (double)(2 * p + l_abs + 1) * psi;
        Double AmpPattern = Math.exp(expFactor * q.imag() / q_abs) * Math.pow(sr, l_abs) * MathUtils.laguerre(p, l_abs, sr * sr);
        Double Spiral = (double)l * phi;
        Double Sphere = expFactor * q.real() / q_abs;
        return Complex.newAbsPhi(factor * AmpPattern * Math.cos(Spiral), Gouyphase + Sphere);
    }

    public double u_pl_cos_amp_xy(int p, int l, double x, double y) {
        Double r = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        Double phi = Math.atan2(x, y);
        return this.u_pl_cos_amp(p, l, r, phi);
    }

    public double u_pl_cos_amp(int p, int l, double r, double phi) {
        int l_abs = Math.abs(l);
        if (l_abs < 0 || p < l_abs) {
            throw new RuntimeException("LG mode index error (0<|l|<p)");
        }
        Complex q = this._qx;
        Double k = Math.PI * 2 / this._lambda * this._nr;
        Double w = GaussMode.w_size(q, this._lambda, this._nr);
        Double sr = Math.sqrt(2.0) * r / w;
        Double q_abs = Complex.absSquared(q);
        Double expFactor = -0.5 * k * r * r;
        Double factor = Math.sqrt((double)(2L * MathUtils.factorial(p)) / (Math.PI * (double)MathUtils.factorial(l_abs + p))) / w;
        Double AmpPattern = Math.exp(expFactor * q.imag() / q_abs) * Math.pow(sr, l_abs) * MathUtils.laguerre(p, l_abs, sr * sr);
        Double Spiral = (double)l * phi;
        return factor * AmpPattern * Math.cos(Spiral);
    }
}

