/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics;

import java.applet.AppletContext;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import org.gwoptics.LogoSize;
import org.gwoptics.graphics.Colour;
import org.gwoptics.graphics.Renderable;
import processing.core.PApplet;
import processing.core.PImage;

public class Logo
extends Renderable {
    private boolean _clickable;
    private PImage _logo;
    private PImage _logoMouseOver;
    private boolean _isMouseOverLogo;

    public Logo(PApplet parent, float x, float y, boolean clickable) {
        this(parent, x, y, clickable, LogoSize.Size35);
    }

    public Logo(PApplet parent, float x, float y, boolean clickable, LogoSize size) {
        super(parent);
        this.position.x = x;
        this.position.y = y;
        this._clickable = clickable;
        parent.registerMouseEvent((Object)this);
        this._logo = parent.loadImage("gwoptics_org_logo_" + size.getSize() + "px.png");
        this._logoMouseOver = parent.loadImage("gwoptics_org_logo_shadow_" + size.getSize() + "px.png");
    }

    public void mouseEvent(MouseEvent event) {
        this._isMouseOverLogo = this._isMouseOver();
        if (event.getID() == 500 && this._isMouseOverLogo && this._clickable) {
            try {
                AppletContext a = this._parent.getAppletContext();
                URL url = new URL("http://www.gwoptics.org");
                a.showDocument(url, "_self");
            }
            catch (MalformedURLException e) {
                PApplet.print((String)e.getMessage());
            }
        }
    }

    public void draw() {
        if (this._isMouseOverLogo) {
            this._parent.image(this._logoMouseOver, this.position.x, this.position.y);
        } else {
            this._parent.image(this._logo, this.position.x, this.position.y);
        }
    }

    public void clearBackground(int borderSize, Colour bgColor) {
        this._parent.pushStyle();
        this._parent.noStroke();
        this._parent.fill(bgColor.toInt());
        this._parent.rect((float)((int)this.position.x - borderSize), (float)((int)this.position.y - borderSize), (float)(this._logo.width + 2 * borderSize), (float)(this._logo.height + 2 * borderSize));
        this._parent.popStyle();
    }

    private boolean _isMouseOver() {
        Rectangle r = new Rectangle((int)this.position.x, (int)this.position.y, this._logo.width, this._logo.height);
        return r.contains(this._parent.mouseX, this._parent.mouseY);
    }
}

