/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.testing;

import processing.core.PApplet;

public class FDTD_2D_PML
extends PApplet {
    float c = 3.0E8f;
    float epi_o = 8.854188E-12f;
    float mu_o = 1.256637E-6f;
    final int src_x = 100;
    final int src_y = 150;
    public Node2D[][] nodes;
    public final int sim_x = 600;
    public final int sim_y = 300;
    final float lambda = 1.0E-7f;
    final float dx = 5.0E-9f;
    final float dy = 5.0E-9f;
    final float dt = 5.0E-9f / (2.0f * this.c);
    float tpif = (float)Math.PI * 2 * this.c / 1.0E-7f;
    int t = 0;
    protected double Cx = this.dt / 5.0E-9f;
    protected double Cy = this.dt / 5.0E-9f;

    public void setup() {
        this.size(600, 300);
        this.nodes = new Node2D[600][300];
        int i = 0;
        while (i < 600) {
            int j = 0;
            while (j < 300) {
                this.nodes[i][j] = new Node2D(i, j);
                ++j;
            }
            ++i;
        }
    }

    public void draw() {
        int j;
        this.background(0);
        int j2 = 1;
        while (j2 < 299) {
            this.nodes[1][j2].Ez = FDTD_2D_PML.sin((float)(this.tpif * (float)this.t * this.dt)) + FDTD_2D_PML.sin((float)(0.1f * this.tpif * (float)this.t * this.dt)) + 0.5f * FDTD_2D_PML.cos((float)(0.05f * this.tpif * (float)this.t * this.dt));
            this.nodes[1][j2].Hx = this.nodes[1][j2].Ez / (double)this.c;
            ++j2;
        }
        ++this.t;
        int i = 1;
        while (i < 600) {
            j = 1;
            while (j < 300) {
                this.nodes[i][j].updateB();
                ++j;
            }
            ++i;
        }
        this.loadPixels();
        i = 1;
        while (i < 599) {
            j = 1;
            while (j < 299) {
                Node2D n = this.nodes[i][j];
                if (!(i <= 50 || i >= 55 || j >= 110 && j <= 120 || j >= 180 && j <= 190)) {
                    n.Ez = 0.0;
                } else {
                    n.updateE();
                }
                this.pixels[j * 600 + i] = n.Ez < 0.0 ? this.color(0, 0, (int)(-255.0 * n.Ez)) : (n.Ez > 0.0 ? this.color((int)(255.0 * n.Ez), 0, 0) : this.color(0));
                ++j;
            }
            ++i;
        }
        this.updatePixels();
        FDTD_2D_PML.println((int)this.t);
    }

    public class CPMLNode2D
    implements INode2D {
        public double Hy = 0.0;
        public double Hx = 0.0;
        public double Ez = 0.0;
        public double epi_r = 1.0;
        public double mu_r = 1.0;
        public double psi_;
        public double sig_m;
        private int i;
        private int j;

        public CPMLNode2D(int i, int j) {
            this.i = i;
            this.j = j;
        }

        public void updateB() {
            this.Hy += FDTD_2D_PML.this.Cy / (this.mu_r * (double)FDTD_2D_PML.this.mu_o) * (FDTD_2D_PML.this.nodes[this.i][this.j].Ez - FDTD_2D_PML.this.nodes[this.i - 1][this.j].Ez);
            this.Hx -= FDTD_2D_PML.this.Cx / (this.mu_r * (double)FDTD_2D_PML.this.mu_o) * (FDTD_2D_PML.this.nodes[this.i][this.j].Ez - FDTD_2D_PML.this.nodes[this.i][this.j - 1].Ez);
        }

        public void updateE() {
            this.Ez += 1.0 / (this.epi_r * (double)FDTD_2D_PML.this.epi_o) * (FDTD_2D_PML.this.Cx * (FDTD_2D_PML.this.nodes[this.i + 1][this.j].Hy - FDTD_2D_PML.this.nodes[this.i][this.j].Hy) - FDTD_2D_PML.this.Cy * (FDTD_2D_PML.this.nodes[this.i][this.j + 1].Hx - FDTD_2D_PML.this.nodes[this.i][this.j].Hx));
        }
    }

    public static interface INode2D {
        public void updateE();

        public void updateB();
    }

    public class Node2D
    implements INode2D {
        public double Hy = 0.0;
        public double Hx = 0.0;
        public double Ez = 0.0;
        public double epi_r = 1.0;
        public double mu_r = 1.0;
        public double sig_e;
        public double sig_m;
        private int i;
        private int j;

        public Node2D(int i, int j) {
            this.i = i;
            this.j = j;
        }

        public void updateB() {
            this.Hy += FDTD_2D_PML.this.Cy / (this.mu_r * (double)FDTD_2D_PML.this.mu_o) * (FDTD_2D_PML.this.nodes[this.i][this.j].Ez - FDTD_2D_PML.this.nodes[this.i - 1][this.j].Ez);
            this.Hx -= FDTD_2D_PML.this.Cx / (this.mu_r * (double)FDTD_2D_PML.this.mu_o) * (FDTD_2D_PML.this.nodes[this.i][this.j].Ez - FDTD_2D_PML.this.nodes[this.i][this.j - 1].Ez);
        }

        public void updateE() {
            this.Ez += 1.0 / (this.epi_r * (double)FDTD_2D_PML.this.epi_o) * (FDTD_2D_PML.this.Cx * (FDTD_2D_PML.this.nodes[this.i + 1][this.j].Hy - FDTD_2D_PML.this.nodes[this.i][this.j].Hy) - FDTD_2D_PML.this.Cy * (FDTD_2D_PML.this.nodes[this.i][this.j + 1].Hx - FDTD_2D_PML.this.nodes[this.i][this.j].Hx));
        }
    }
}

