/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.testing;

import processing.core.PApplet;

public class FDTD_2D
extends PApplet {
    float c = 3.0E8f;
    float epi_o = 8.854188E-12f;
    float mu_o = 1.256637E-6f;
    final int src_x = 100;
    final int src_y = 150;
    public Node2D[][] nodes;
    public final int sim_x = 600;
    public final int sim_y = 600;
    final float lambda = 1.0E-7f;
    final float dx = 3.3333334E-9f;
    final float dy = 3.3333334E-9f;
    final float dt = 3.3333334E-9f / (2.0f * this.c);
    float tpif = (float)Math.PI * 2 * this.c / 1.0E-7f;
    int t = 0;

    public void setup() {
        this.size(600, 600);
        this.nodes = new Node2D[600][600];
        int i = 0;
        while (i < 600) {
            int j = 0;
            while (j < 600) {
                this.nodes[i][j] = new Node2D();
                ++j;
            }
            ++i;
        }
    }

    public void draw() {
        int j;
        this.background(0);
        int j2 = 0;
        while (j2 < 600) {
            this.nodes[300][j2].Ez = FDTD_2D.sin((float)(this.tpif * (float)this.t * this.dt));
            ++j2;
        }
        ++this.t;
        double Cx = this.dt / 3.3333334E-9f;
        double Cy = this.dt / 3.3333334E-9f;
        int i = 1;
        while (i < 600) {
            j = 1;
            while (j < 600) {
                Node2D n = this.nodes[i][j];
                n.Hy += Cy / (n.mu_r * (double)this.mu_o) * (this.nodes[i][j].Ez - this.nodes[i - 1][j].Ez);
                n.Hx -= Cx / (n.mu_r * (double)this.mu_o) * (this.nodes[i][j].Ez - this.nodes[i][j - 1].Ez);
                ++j;
            }
            ++i;
        }
        this.loadPixels();
        i = 1;
        while (i < 599) {
            j = 1;
            while (j < 599) {
                Node2D n = this.nodes[i][j];
                n.Ez = !(i != 50 || j >= 115 && j <= 120 || j >= 180 && j <= 185) ? 0.0 : (n.Ez += 1.0 / (n.epi_r * (double)this.epi_o) * (Cx * (this.nodes[i + 1][j].Hy - this.nodes[i][j].Hy) - Cy * (this.nodes[i][j + 1].Hx - this.nodes[i][j].Hx)));
                this.pixels[j * 600 + i] = n.Ez < 0.0 ? this.color(0, 0, (int)(-255.0 * n.Ez)) : (n.Ez > 0.0 ? this.color((int)(255.0 * n.Ez), 0, 0) : this.color(0));
                ++j;
            }
            ++i;
        }
        this.updatePixels();
        FDTD_2D.println((int)this.t);
    }

    public final class Node2D {
        public double Hy = 0.0;
        public double Hx = 0.0;
        public double Ez = 0.0;
        public double epi_r = 1.0;
        public double mu_r = 1.0;
    }
}

