/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.backgrounds;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.graph2D.backgrounds.SolidColourBackground;

public class GridBackground
extends SolidColourBackground {
    protected GWColour _gridXColour;
    protected GWColour _gridYColour;
    protected boolean _showX = true;
    protected boolean _showY = true;

    public GridBackground() {
        super(new GWColour(255, 255, 255));
        this._gridXColour = new GWColour(0, 0, 0);
        this._gridYColour = new GWColour(0, 0, 0);
    }

    public GridBackground(GWColour background) {
        super(background);
        this._gridXColour = new GWColour(0, 0, 0);
        this._gridYColour = new GWColour(0, 0, 0);
    }

    public GridBackground(GWColour gridColour, GWColour background) {
        super(background);
        this._gridXColour = gridColour;
        this._gridYColour = gridColour;
    }

    public GridBackground(GWColour gridColour, GWColour background, boolean ShowXAxisLines, boolean ShowYAxisLines) {
        super(background);
        this._showX = ShowXAxisLines;
        this._showY = ShowYAxisLines;
        this._gridXColour = gridColour;
        this._gridYColour = gridColour;
    }

    public void setGridColour(int R, int G, int B) {
        this._gridYColour = new GWColour(R, G, B);
        this._gridXColour = new GWColour(R, G, B);
    }

    public void setGridColour(int Rx, int Gx, int Bx, int Ry, int Gy, int By) {
        this._gridYColour = new GWColour(Ry, Gy, By);
        this._gridXColour = new GWColour(Rx, Gx, Bx);
    }

    public void setNoGrid() {
        this._gridXColour = null;
        this._gridYColour = null;
    }

    public void setGridLines(boolean ShowXAxisLines, boolean ShowYAxisLines) {
        this._showX = ShowXAxisLines;
        this._showY = ShowYAxisLines;
    }

    public void draw() {
        super.draw();
        if (this._parent != null && this._gridYColour != null && this._gridXColour != null) {
            Integer i;
            int n;
            int n2;
            Integer[] integerArray;
            this._parent.stroke(this._gridXColour.toInt());
            if (this._ax.getMajorTickPositions() != null && this._showX) {
                integerArray = this._ax.getMajorTickPositions();
                n2 = integerArray.length;
                n = 0;
                while (n < n2) {
                    i = integerArray[n];
                    this._parent.line((float)i.intValue(), 0.0f, (float)i.intValue(), (float)(-this._ay.getLength()));
                    ++n;
                }
            }
            this._parent.stroke(this._gridYColour.toInt());
            if (this._ay.getMajorTickPositions() != null && this._showY) {
                integerArray = this._ay.getMajorTickPositions();
                n2 = integerArray.length;
                n = 0;
                while (n < n2) {
                    i = integerArray[n];
                    this._parent.line(0.0f, (float)(-i.intValue()), (float)this._ax.getLength(), (float)(-i.intValue()));
                    ++n;
                }
            }
        }
    }
}

