/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.colourmap;

import java.util.ArrayList;
import java.util.Arrays;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.colourmap.ColourmapNode;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.colourmap.MapNeedsGeneratingException;

public class RGBColourmap
implements IColourmap {
    private GWColour[] _cColourmapLookup;
    private int[] _iColourmapLookup;
    private ArrayList<ColourmapNode> _nodes;
    private float _dLoc;
    private boolean _needsGenerating;
    private boolean _isCentreAtZero;

    public boolean isCentreAtZero() {
        return this._isCentreAtZero;
    }

    public void setCentreAtZero(boolean value) {
        this._isCentreAtZero = value;
    }

    public RGBColourmap() {
        this._cColourmapLookup = new GWColour[100];
        this._nodes = new ArrayList();
        this._dLoc = 0.015873017f;
        this._iColourmapLookup = new int[64];
        this._needsGenerating = true;
    }

    public RGBColourmap(int resolution) {
        this._cColourmapLookup = new GWColour[resolution];
        this._nodes = new ArrayList();
        this._dLoc = 1.0f / (float)(resolution - 1);
        this._iColourmapLookup = new int[resolution];
        this._needsGenerating = true;
    }

    public boolean isGenerated() {
        return !this._needsGenerating;
    }

    public void addNode(ColourmapNode n) {
        ColourmapNode node = new ColourmapNode();
        node.location = n.location < 0.0f ? 0.0f : (n.location > 1.0f ? 1.0f : n.location);
        node.colour.A = n.colour.A < 0.0f ? 0.0f : (n.colour.A > 1.0f ? 1.0f : n.colour.A);
        node.colour.R = n.colour.R < 0.0f ? 0.0f : (n.colour.R > 1.0f ? 1.0f : n.colour.R);
        node.colour.G = n.colour.G < 0.0f ? 0.0f : (n.colour.G > 1.0f ? 1.0f : n.colour.G);
        node.colour.B = n.colour.B < 0.0f ? 0.0f : (n.colour.B > 1.0f ? 1.0f : n.colour.B);
        this._nodes.add(node);
        this._needsGenerating = true;
    }

    public void generateColourmap() {
        Object[] nodeArray = this._nodes.toArray(new ColourmapNode[this._nodes.size()]);
        if (nodeArray.length > 1) {
            Arrays.sort(nodeArray);
            int i = 0;
            while (i < nodeArray.length - 1) {
                int i2;
                Object n1 = nodeArray[i];
                Object n2 = nodeArray[i + 1];
                int i1 = Math.round(((ColourmapNode)n1).location / this._dLoc);
                if (i1 != (i2 = Math.round(((ColourmapNode)n2).location / this._dLoc))) {
                    if (i == 0) {
                        float cfr_ignored_0 = ((ColourmapNode)n1).location;
                    } else if (i == nodeArray.length - 1) {
                        float cfr_ignored_1 = ((ColourmapNode)n1).location;
                    }
                    float steps = i2 - i1;
                    float dAlpha = (((ColourmapNode)n2).colour.A - ((ColourmapNode)n1).colour.A) / steps;
                    float dRed = (((ColourmapNode)n2).colour.R - ((ColourmapNode)n1).colour.R) / steps;
                    float dGreen = (((ColourmapNode)n2).colour.G - ((ColourmapNode)n1).colour.G) / steps;
                    float dBlue = (((ColourmapNode)n2).colour.B - ((ColourmapNode)n1).colour.B) / steps;
                    int j = 0;
                    while (j < i2 - i1 + 1) {
                        this._cColourmapLookup[j + i1] = new GWColour(((ColourmapNode)n1).colour.A + (float)j * dAlpha, ((ColourmapNode)n1).colour.R + (float)j * dRed, ((ColourmapNode)n1).colour.G + (float)j * dGreen, ((ColourmapNode)n1).colour.B + (float)j * dBlue);
                        this._iColourmapLookup[j + i1] = GWColour.convertColourToInt(this._cColourmapLookup[j + i1]);
                        ++j;
                    }
                }
                ++i;
            }
        } else if (nodeArray.length == 1) {
            Object node = nodeArray[0];
            int i = 0;
            while (i < this._cColourmapLookup.length) {
                this._cColourmapLookup[i] = new GWColour(((ColourmapNode)node).colour.A, ((ColourmapNode)node).colour.R, ((ColourmapNode)node).colour.G, ((ColourmapNode)node).colour.B);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._cColourmapLookup.length) {
                this._cColourmapLookup[i] = new GWColour(0, 0, 0);
                ++i;
            }
        }
        this._needsGenerating = false;
    }

    public GWColour getColourAtLocation(float l) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float loc = l < 0.0f ? 0.0f : (l > 1.0f ? 1.0f : l);
        return this._cColourmapLookup[Math.round(loc / this._dLoc)];
    }

    public int getIntAtLocation(float l) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float loc = l < 0.0f ? 0.0f : (l > 1.0f ? 1.0f : l);
        return this._iColourmapLookup[Math.round(loc / this._dLoc)];
    }

    public ColourmapNode getNode(int i) {
        if (this._nodes.size() <= i) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._nodes.get(i);
    }

    public void setNode(int i, ColourmapNode node) {
        if (this._nodes.size() <= i) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._nodes.set(i, node);
    }

    public void removeNode(int i) {
        if (this._nodes.size() <= i) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._nodes.remove(i);
    }

    public int getNodeCount() {
        return this._nodes.size();
    }
}

