/*
 * Decompiled with CFR 0.152.
 */
import fullscreen.FullScreen;
import org.gwoptics.Logo;
import org.gwoptics.LogoSize;
import org.gwoptics.graphics.GWColour;
import processing.core.PApplet;
import processing.core.PImage;
import processing.video.Capture;

public class StretchAndSquash
extends PApplet {
    FullScreen fs;
    private int _polar = 0;
    private int _imgOp = 2;
    private boolean paused = false;
    float def_amp;
    private float h_plus_amp = this.def_amp = 0.18f;
    private float h_cross_amp = 0.0f;
    private float h_frequency = 0.025f;
    private float h_Phase = 0.0f;
    private final int XRes = 800;
    private final int YRes = 600;
    private PImage _imgMichelson;
    private PImage _imgGrid;
    private PImage _imgTestMass;
    private PImage _imgplus;
    private PImage _imgcross;
    private PImage _imgcirc;
    Logo _logo;
    private PImage _ETLogo;
    private PImage _BHAMLogo;
    private Capture _camCapture;
    private boolean _useWebCam;
    public final int Num_Processors;
    protected PImage _img;
    protected PImage _inImg;
    private GWImageDistorter imgDst;
    private float _time;
    private Object _lock = new Object();
    boolean camera_found = true;

    public StretchAndSquash() {
        this.Num_Processors = Runtime.getRuntime().availableProcessors();
        PApplet.println((String)("Using " + this.Num_Processors + " Processors."));
    }

    public void setup() {
        this.size(800, 600, "processing.core.PGraphics2D");
        this.frameRate(25.0f);
        this.fs = new FullScreen((PApplet)this);
        this._imgcirc = this.loadImage("circular_label.png");
        this._imgplus = this.loadImage("plus_label.png");
        this._imgcross = this.loadImage("cross_label.png");
        this._imgMichelson = this.loadImage("michelson03.png");
        this._imgTestMass = this.loadImage("testmasses2.png");
        this._imgGrid = this.loadImage("grid.png");
        this._logo = new Logo((PApplet)this, 5.0f, 560.0f, true, LogoSize.Size35);
        this._ETLogo = this.loadImage("et.jpg");
        this._BHAMLogo = this.loadImage("bhamlogo2.jpg");
        String string = System.getProperty("os.name");
        if (string.equals("Mac OS X")) {
            StretchAndSquash.println((String)"Running on OS X, checking for webcam...");
            try {
                Capture.list();
            }
            catch (Exception exception) {
                this.camera_found = false;
                StretchAndSquash.println((String)"Web camera not found.");
            }
        } else {
            this.camera_found = false;
        }
        if (this.camera_found) {
            StretchAndSquash.println((String)"Web camera found.");
        } else {
            this._camCapture = null;
        }
        this._img = new PImage(800, 600);
        this.imgDst = new GWImageDistorter(this, 2, this._inImg, this._img);
        this.imgDst.setImageInput(this._imgTestMass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureEvent(Capture capture) {
        if (!this.paused) {
            if (this._imgOp == 0) {
                capture.read();
            }
            if (this.imgDst != null) {
                GWImageDistorter gWImageDistorter = this.imgDst;
                synchronized (gWImageDistorter) {
                    if (this._imgOp == 0) {
                        this.imgDst.setImageInput(capture.get());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed() {
        GWImageDistorter gWImageDistorter = this.imgDst;
        synchronized (gWImageDistorter) {
            if (this.key == ' ') {
                if (this.paused) {
                    this.unpause();
                } else {
                    this.pause();
                }
            } else if (this.key == 'p') {
                if (this._polar == 0) {
                    this.h_cross_amp = this.def_amp;
                    this.h_plus_amp = 0.0f;
                    this.h_Phase = 0.0f;
                    this._polar = 1;
                } else if (this._polar == 1) {
                    this.h_cross_amp = 0.75f * this.def_amp;
                    this.h_plus_amp = 0.75f * this.def_amp;
                    this.h_Phase = -1.5707964f;
                    this._polar = 2;
                } else if (this._polar == 2) {
                    this.h_cross_amp = 0.0f;
                    this.h_plus_amp = this.def_amp;
                    this.h_Phase = 0.0f;
                    this._polar = 0;
                }
                this.unpause();
            } else if (this.key == 'v') {
                if (this._imgOp == 0) {
                    this._imgOp = 1;
                    this._camCapture.stop();
                    this._camCapture.dispose();
                    this.imgDst.setImageInput(this._imgMichelson);
                } else if (this._imgOp == 1) {
                    this._imgOp = 2;
                    this.imgDst.setImageInput(this._imgTestMass);
                } else if (this._imgOp == 2) {
                    this._imgOp = 3;
                    this.imgDst.setImageInput(this._imgGrid);
                } else if (this._imgOp == 3) {
                    if (!this.camera_found) {
                        this._imgOp = 1;
                        this.imgDst.setImageInput(this._imgMichelson);
                    } else {
                        StretchAndSquash.println((String)"Switching to video");
                        this._camCapture = new Capture((PApplet)this, 960, 720, 60);
                        this._inImg = null;
                        this._imgOp = 0;
                    }
                }
                this.unpause();
            } else if (this.key == 'i') {
                ImageWorker.interpol();
                this.unpause();
            }
        }
    }

    public void pause() {
        this.paused = true;
        this.imgDst.pause();
    }

    public void unpause() {
        this.paused = false;
        this.imgDst.play();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw() {
        this.background(200);
        this.noStroke();
        GWImageDistorter gWImageDistorter = this.imgDst;
        synchronized (gWImageDistorter) {
            this.imgDst.updateImage(this._time, this.h_frequency, this.h_plus_amp, this.h_cross_amp, 0.0f, this.h_Phase);
        }
        this.image(this._img, 0.0f, 0.0f);
        if (this._imgOp == 3 || this._imgOp == 0) {
            this._logo.clearBackground(5, new GWColour(255, 255, 255));
        }
        this._logo.draw();
        this.image(this._BHAMLogo, 800 - this._BHAMLogo.width, 600 - this._BHAMLogo.height);
        switch (this._polar) {
            case 0: {
                this.image(this._imgplus, 10.0f, 10.0f);
                break;
            }
            case 1: {
                this.image(this._imgcross, 10.0f, 17.0f);
                break;
            }
            case 2: {
                this.image(this._imgcirc, 10.0f, 15.0f);
            }
        }
        if (!this.paused) {
            this._time += 0.25f;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"StretchAndSquash"});
    }
}

