/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.CountDownLatch;
import org.gwoptics.mathutils.TrigLookup;
import processing.core.PConstants;
import processing.core.PImage;

public class ImageWorker
implements Runnable,
PConstants {
    private int _start;
    private int _end;
    private Object _processingLock = new Object();
    static boolean interpolate = true;
    public float time;
    public float h_plus_amp;
    public float h_cross_amp;
    public float frequency;
    public float h_plus_phs;
    public float h_cross_phs;
    private PImage _outImg;
    private PImage _inImg;
    private int _imgOffsetX;
    private int _imgOffsetY;
    private int _inImgOffsetX;
    private int _inImgOffsetY;
    private CountDownLatch _stillRunning;

    public void setStartIndex(int n) {
        this._start = n;
    }

    public void setEndIndex(int n) {
        this._end = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputImage(PImage pImage) {
        Object object = this._processingLock;
        synchronized (object) {
            this._outImg = pImage;
            this._imgOffsetX = Math.round((float)this._outImg.width * 0.5f);
            this._imgOffsetY = Math.round((float)this._outImg.height * 0.5f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCountDownLatch(CountDownLatch countDownLatch) {
        Object object = this._processingLock;
        synchronized (object) {
            this._stillRunning = countDownLatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputImage(PImage pImage) {
        Object object = this._processingLock;
        synchronized (object) {
            if (pImage == null) {
                throw new NullPointerException("Input image nulled");
            }
            this._inImg = pImage;
            this._inImgOffsetX = Math.round((float)this._inImg.width * 0.5f);
            this._inImgOffsetY = Math.round((float)this._inImg.height * 0.5f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this._processingLock;
        synchronized (object) {
            if (this._inImg != null) {
                float f = (float)Math.PI * 2 * (this.frequency * this.time);
                float f2 = f + (float)Math.PI;
                double d = 0.5 + (double)this.h_cross_amp * TrigLookup.sin((float)(f + this.h_cross_phs));
                double d2 = 0.5 + (double)this.h_cross_amp * TrigLookup.sin((float)(f2 + this.h_cross_phs));
                double d3 = 0.5 + (double)this.h_plus_amp * TrigLookup.sin((float)(f + this.h_plus_phs));
                double d4 = 0.5 + (double)this.h_plus_amp * TrigLookup.sin((float)(f2 + this.h_plus_phs));
                double d5 = (d + d2) * 0.5;
                double d6 = (d - d2) * 0.5;
                double d7 = d4 + d5;
                double d8 = d3 + d5;
                int n = this._start;
                while (n < this._end) {
                    int n2 = n / this._outImg.width;
                    int n3 = n - n2 * this._outImg.width;
                    float f3 = (float)((double)(n3 -= this._imgOffsetX) * d7 + (double)(n2 -= this._imgOffsetY) * d6) + (float)this._inImgOffsetX;
                    float f4 = (float)((double)n3 * d6 + (double)n2 * d8) + (float)this._inImgOffsetY;
                    int n4 = (int)f3;
                    int n5 = (int)f4;
                    int n6 = n5 * this._inImg.width + n4;
                    if (interpolate) {
                        int n7 = n6 + 1;
                        int n8 = n6 + this._inImg.width;
                        int n9 = n8 + 1;
                        if (n6 >= 0 && n9 < this._inImg.pixels.length) {
                            float f5 = f3 - (float)n4;
                            float f6 = f4 - (float)n5;
                            int n10 = this._inImg.pixels[n6];
                            int n11 = this._inImg.pixels[n7];
                            int n12 = this._inImg.pixels[n8];
                            int n13 = this._inImg.pixels[n9];
                            this._outImg.pixels[n] = this.mylerp(n10, n11, n12, n13, f5, f6);
                        } else {
                            this._outImg.pixels[n] = 0xAAAAAA;
                        }
                    } else {
                        this._outImg.pixels[n] = n6 >= 0 && n6 < this._inImg.pixels.length ? this._inImg.pixels[n6] : 0xAAAAAA;
                    }
                    ++n;
                }
            }
            this._stillRunning.countDown();
        }
    }

    int mylerp(int n, int n2, int n3, int n4, float f, float f2) {
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 & 0xFF;
        int n11 = n3 >> 16 & 0xFF;
        int n12 = n3 >> 8 & 0xFF;
        int n13 = n3 & 0xFF;
        int n14 = n4 >> 16 & 0xFF;
        int n15 = n4 >> 8 & 0xFF;
        int n16 = n4 & 0xFF;
        int n17 = (int)(((float)n5 * (1.0f - f) + (float)n8 * f) * (1.0f - f2) + ((float)n11 * (1.0f - f) + (float)n14 * f) * f2);
        int n18 = (int)(((float)n6 * (1.0f - f) + (float)n9 * f) * (1.0f - f2) + ((float)n12 * (1.0f - f) + (float)n15 * f) * f2);
        int n19 = (int)(((float)n7 * (1.0f - f) + (float)n10 * f) * (1.0f - f2) + ((float)n13 * (1.0f - f) + (float)n16 * f) * f2);
        return n17 << 16 | n18 << 8 | n19;
    }

    public static void interpol() {
        interpolate = !interpolate;
    }
}

