/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Arrays;

public class Interpolator {
    public static final double[] interpLinear(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("X and Y must be the same length");
        }
        if (dArray.length == 1) {
            throw new RuntimeException("X must contain more than one value");
        }
        double[] dArray4 = new double[dArray.length - 1];
        double[] dArray5 = new double[dArray.length - 1];
        double[] dArray6 = new double[dArray.length - 1];
        double[] dArray7 = new double[dArray.length - 1];
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray4[i] = dArray[i + 1] - dArray[i];
            if (dArray4[i] == 0.0) {
                throw new RuntimeException("X must be montotonic. A duplicate x-value was found");
            }
            if (dArray4[i] < 0.0) {
                throw new RuntimeException("X must be sorted");
            }
            dArray5[i] = dArray2[i + 1] - dArray2[i];
            dArray6[i] = dArray5[i] / dArray4[i];
            dArray7[i] = dArray2[i] - dArray[i] * dArray6[i];
        }
        double[] dArray8 = new double[dArray3.length];
        for (int i = 0; i < dArray3.length; ++i) {
            if (dArray3[i] > dArray[dArray.length - 1] || dArray3[i] < dArray[0]) {
                dArray8[i] = Double.NaN;
                continue;
            }
            int n = Arrays.binarySearch(dArray, dArray3[i]);
            if (n < -1) {
                n = -n - 2;
                dArray8[i] = dArray6[n] * dArray3[i] + dArray7[n];
                continue;
            }
            dArray8[i] = dArray2[n];
        }
        return dArray8;
    }
}

