/*
 * Decompiled with CFR 0.152.
 */
package pages.vibrationisolation;

import core.ResourceManager;
import core.ScreenElement;
import core.gui.GLabel;
import core.gui.GWSlider;
import core.gui.TextBlockElement;
import core.language.Language;
import game.variables.OpticsVariables;
import game.variables.SuspensionVariables;
import processing.core.PApplet;
import processing.core.PImage;

public class Suspensions
extends ScreenElement {
    private PImage _Pmirror1;
    private PImage _Pmirror2;
    private PImage _Pmirror3;
    private PImage _Pmirror4;
    private PImage _Pwires;
    private GWSlider _sldLength;
    private GWSlider _sldNumber;
    private GWSlider _sldWeight;
    private GLabel _title;
    private GLabel _cost;
    private TextBlockElement _sspNumTxt;
    private TextBlockElement _sspLgtTxt;
    private TextBlockElement _sspWgtTxt;
    private String titletext = "Number of Stages";

    public Suspensions(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setRelativeBounds(0.75f, 1.0f);
        this._sspNumTxt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Vibration_num_text"), 18, 0.36f, 0.4f);
        this._sspNumTxt.setRelativePosition(0.61f, 0.08f);
        this._sspLgtTxt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Vibration_lgt_text"), 18, 0.36f, 0.4f);
        this._sspLgtTxt.setRelativePosition(0.61f, 0.08f);
        this._sspWgtTxt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Vibration_wgt_text"), 18, 0.36f, 0.4f);
        this._sspWgtTxt.setRelativePosition(0.61f, 0.08f);
        this._title = new GLabel(this, pApplet, this.titletext, 0.6f, 0.01f, (int)((float)this.getWidth() * 0.36f));
        this._title.setFont(Language.getString("Font_Default"), 20);
        this._sldLength = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.45f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.35f));
        this._sldLength.setRelativePosition(0.61f, 0.55f);
        this._sldLength.setLimits(SuspensionVariables.PendLength, 35.0f, 500.0f);
        this._sldLength.setFontColour(255, 255, 255);
        this._sldLength.setFont(Language.getString("Font_Default"), 17);
        this._sldLength.setUnit("cm");
        this._sldLength.setVisible(true);
        this._sldNumber = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.45f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.35f));
        this._sldNumber.setRelativePosition(0.61f, 0.55f);
        this._sldNumber.setLimits(SuspensionVariables.PendNumber, 1.0f, 9.0f);
        this._sldNumber.setFontColour(255, 255, 255);
        this._sldNumber.setFont(Language.getString("Font_Default"), 17);
        this._sldNumber.setUnit(" ");
        this._sldNumber.setVisible(true);
        this._sldNumber.setTickCount(8);
        this._sldWeight = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.45f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.35f));
        this._sldWeight.setRelativePosition(0.61f, 0.55f);
        this._sldWeight.setLimits(SuspensionVariables.PendMass, 5.0f, 100.0f);
        this._sldWeight.setFontColour(255, 255, 255);
        this._sldWeight.setFont(Language.getString("Font_Default"), 17);
        this._sldWeight.setUnit("kg");
        this._sldWeight.setVisible(true);
        this._cost = new GLabel(this, pApplet, Language.getString("Vibration_cost") + ":", 0.95f, 0.65f, (int)((float)this.getWidth() * 0.35f));
        this._cost.setFont(Language.getString("Font_Default"), 18);
        this._cost.setOrigin(1.0f, 0.5f);
        this._cost.setTextAlign(2);
        this.addChild(this._title);
        this.addChild(this._sldLength);
        this.addChild(this._sldWeight);
        this.addChild(this._sldNumber);
        this.addChild(this._cost);
        this.addChild(this._sspNumTxt);
        this.addChild(this._sspLgtTxt);
        this.addChild(this._sspWgtTxt);
    }

    public void reset() {
        this._sldWeight.setLimits(SuspensionVariables.PendMass, 5.0f, 100.0f);
        this._sldNumber.setLimits(SuspensionVariables.PendNumber, 1.0f, 9.0f);
        this._sldLength.setLimits(SuspensionVariables.PendLength, 35.0f, 500.0f);
    }

    @Override
    public void setup() {
    }

    @Override
    public void loadResources() {
        this._Pmirror4 = ResourceManager.LoadImage("suspendedmirror_4.png");
        this._Pmirror1 = ResourceManager.LoadImage("suspendedmirror_1.png");
        this._Pmirror2 = ResourceManager.LoadImage("suspendedmirror_2.png");
        this._Pmirror3 = ResourceManager.LoadImage("suspendedmirror_3.png");
        this._Pwires = ResourceManager.LoadImage("suspensionwire.png");
    }

    @Override
    public void update(float f) {
        SuspensionVariables.PendLength = this._sldLength.getValuef() / 100.0f;
        SuspensionVariables.PendTotLength = this._sldLength.getValuef() * this._sldNumber.getValuef();
        SuspensionVariables.PendNumber = this._sldNumber.getValuef();
        SuspensionVariables.PendMass = this._sldWeight.getValuef();
        if (SuspensionVariables.SuspSubs == "SuspNum") {
            this._sldNumber.setVisible(true);
            this._sldLength.setVisible(false);
            this._sldWeight.setVisible(false);
            this._sspNumTxt.setVisible(true);
            this._sspLgtTxt.setVisible(false);
            this._sspWgtTxt.setVisible(false);
            this.titletext = Language.getString("Vibration_num_title");
        }
        if (SuspensionVariables.SuspSubs == "SuspLen") {
            this._sldNumber.setVisible(false);
            this._sldLength.setVisible(true);
            this._sldWeight.setVisible(false);
            this._sspNumTxt.setVisible(false);
            this._sspLgtTxt.setVisible(true);
            this._sspWgtTxt.setVisible(false);
            this.titletext = Language.getString("Vibration_lgt_title");
        }
        if (SuspensionVariables.SuspSubs == "SuspMas") {
            this._sldNumber.setVisible(false);
            this._sldLength.setVisible(false);
            this._sldWeight.setVisible(true);
            this._sspNumTxt.setVisible(false);
            this._sspLgtTxt.setVisible(false);
            this._sspWgtTxt.setVisible(true);
            this.titletext = Language.getString("Vibration_wgt_title");
        }
        this._cost.setText(Language.getString("Vibration_cost") + ": " + this.FormatMoney(SuspensionVariables.getPendCost()));
        this._title.setText(this.titletext);
    }

    @Override
    public void render() {
        float f = PApplet.pow((float)this._sldWeight.getValue() / (float)Math.PI / 2500.0f, 0.33333334f) * 100.0f * 2.0f * 2.0f;
        float f2 = f / (float)this._Pmirror1.height * (float)this._Pmirror1.width;
        float f3 = PApplet.max((float)this._sldLength.getValue(), f);
        float f4 = (float)this._Pwires.width / (float)this._Pmirror1.height * f * PApplet.pow((float)this._sldWeight.getValue() / 10.0f, 0.5f) / 2.0f;
        int n = 0;
        while ((float)n < SuspensionVariables.PendNumber) {
            this._app.image(this._Pwires, 200.0f - f2 / 10.0f * 1.9f, f3 * (float)n, f4, f3);
            this._app.image(this._Pwires, 200.0f - f2 / 10.0f * 2.3f, f3 * (float)n, f4, f3);
            ++n;
        }
        n = 0;
        while ((float)n < SuspensionVariables.PendNumber) {
            this._app.imageMode(3);
            if (OpticsVariables.mirror_material == Language.getString("Fused_Silica")) {
                this._app.image(this._Pmirror1, 200.0f, f3 * (float)(n + 1), f2, f);
            } else if (OpticsVariables.mirror_material == Language.getString("Silicon")) {
                this._app.image(this._Pmirror2, 200.0f, f3 * (float)(n + 1), f2, f);
            } else if (OpticsVariables.mirror_material == Language.getString("Glass")) {
                this._app.image(this._Pmirror3, 200.0f, f3 * (float)(n + 1), f2, f);
            } else if (OpticsVariables.mirror_material == Language.getString("Sapphire")) {
                this._app.image(this._Pmirror4, 200.0f, f3 * (float)(n + 1), f2, f);
            }
            this._app.imageMode(0);
            ++n;
        }
        n = 0;
        while ((float)n < SuspensionVariables.PendNumber) {
            this._app.image(this._Pwires, 200.0f + f2 / 10.0f * 3.9f, f3 * (float)n, f4, f3);
            this._app.image(this._Pwires, 200.0f + f2 / 10.0f * 4.2f, f3 * (float)n, f4, f3);
            ++n;
        }
    }
}

