/*
 * Decompiled with CFR 0.152.
 */
package pages.pioffice.elements;

import core.ImageElement;
import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import ddf.minim.AudioPlayer;
import java.util.Random;
import processing.core.PApplet;
import processing.core.PConstants;

public class PInvestigator
extends ScreenElement
implements PConstants {
    private PIHead head;
    private ImageElement chair;
    public KeyFrameAnimation ShowPI;
    public KeyFrameAnimation HidePI;
    private AudioPlayer typing;

    public PInvestigator(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.head = new PIHead((ScreenElement)this, pApplet);
        this.chair = new ImageElement("chair.png", this, pApplet);
        this.addChild(this.head);
        this.addChild(this.chair);
    }

    @Override
    public void loadResources() {
        this.setBounds(this.chair.getWidth(), this.chair.getHeight());
        this.typing = ResourceManager.LoadAudio("audio/42393__maarten_wez__me_typing_short.mp3");
        if (this.typing != null) {
            this.typing.setGain(-2.0f);
        }
    }

    @Override
    public void setup() {
        this.head.setRelativePosition(0.5f, 0.1f);
        this.ShowPI = new KeyFrameAnimation();
        this.ShowPI.AddKeyFrame(new PVectorKeyFrame(0.0f, 330.0f, 700.0f, TargetProperty.position, EasingFunctions.EaseOut));
        this.ShowPI.AddKeyFrame(new PVectorKeyFrame(1.5f, 330.0f, 340.0f, TargetProperty.position));
        this.ShowPI.AddTargetObject(this);
        this.HidePI = new KeyFrameAnimation();
        this.HidePI.AddKeyFrame(new PVectorKeyFrame(0.0f, 330.0f, 340.0f, TargetProperty.position, EasingFunctions.EaseOut));
        this.HidePI.AddKeyFrame(new PVectorKeyFrame(1.5f, 330.0f, 700.0f, TargetProperty.position));
        this.HidePI.AddTargetObject(this);
    }

    @Override
    public void update(float f) {
        this.ShowPI.Update(f);
        this.HidePI.Update(f);
        if (this.HidePI.isRunning() && this.typing != null) {
            this.typing.pause();
        }
    }

    @Override
    public void onPageHide() {
        if (this.typing != null) {
            this.typing.pause();
        }
    }

    public class PIHead
    extends ImageElement {
        KeyFrameAnimation headWobbleLeft;
        KeyFrameAnimation headWobbleRight;
        KeyFrameAnimation headDown;
        KeyFrameAnimation headUp;
        private Random rand;
        private float headWait;
        private float elapsedTime;
        private boolean goLeft;
        private boolean goDown;
        private boolean animRunning;

        public PIHead(ScreenElement screenElement, PApplet pApplet) {
            super("PIback.png", screenElement, pApplet);
            this.rand = new Random();
            this.headWait = 10.0f;
            this.elapsedTime = 0.0f;
            this.goLeft = true;
            this.goDown = true;
            this.animRunning = false;
        }

        @Override
        public void setup() {
            this.setOrigin(0.5f, 1.0f);
            this.setRelativePosition(0.5f, 40.0f / (float)this.getParent().getHeight());
            this.headWobbleLeft = new KeyFrameAnimation(false, this, new Complete());
            this.headWobbleLeft.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.07853982f), TargetProperty.rotation, EasingFunctions.EaseInOut));
            this.headWobbleLeft.AddKeyFrame(new FloatKeyFrame(1.5f, Float.valueOf(-0.07853982f), TargetProperty.rotation));
            this.headWobbleRight = new KeyFrameAnimation(false, this, new Complete());
            this.headWobbleRight.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(-0.07853982f), TargetProperty.rotation, EasingFunctions.EaseInOut));
            this.headWobbleRight.AddKeyFrame(new FloatKeyFrame(1.5f, Float.valueOf(0.07853982f), TargetProperty.rotation));
            this.headDown = new KeyFrameAnimation(false, this, new Complete());
            this.headDown.AddKeyFrame(new PVectorKeyFrame(0.0f, Float.NaN, 40.0f, TargetProperty.position, EasingFunctions.EaseInOut));
            this.headDown.AddKeyFrame(new PVectorKeyFrame(1.0f, Float.NaN, 50.0f, TargetProperty.position));
            this.headUp = new KeyFrameAnimation(false, this, new Complete());
            this.headUp.AddKeyFrame(new PVectorKeyFrame(0.0f, Float.NaN, 50.0f, TargetProperty.position, EasingFunctions.EaseInOut));
            this.headUp.AddKeyFrame(new PVectorKeyFrame(1.0f, Float.NaN, 40.0f, TargetProperty.position));
        }

        @Override
        public void update(float f) {
            if (!this.animRunning) {
                this.elapsedTime += f;
                if (this.elapsedTime > this.headWait) {
                    if (this.rand.nextFloat() > 0.5f) {
                        if (this.goLeft) {
                            this.headWobbleLeft.Start();
                            this.goLeft = false;
                        } else {
                            this.headWobbleRight.Start();
                            this.goLeft = true;
                        }
                    } else if (this.goDown) {
                        this.headDown.Start();
                        this.goDown = false;
                    } else {
                        this.headUp.Start();
                        this.goDown = true;
                    }
                    this.animRunning = true;
                }
            } else {
                this.headWobbleRight.Update(f);
                this.headWobbleLeft.Update(f);
                this.headDown.Update(f);
                this.headUp.Update(f);
            }
        }

        public class Complete
        implements IAnimationCompleteCallback {
            @Override
            public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
                if (PInvestigator.this.typing != null && !PInvestigator.this.typing.isPlaying()) {
                    PInvestigator.this.typing.loop();
                }
                PIHead.this.elapsedTime = 0.0f;
                PIHead.this.animRunning = false;
                PIHead.this.headWait = 4.0f + PIHead.this.rand.nextFloat() * 4.0f;
            }
        }
    }
}

