/*
 * Decompiled with CFR 0.152.
 */
package pages.pioffice.elements;

import core.GameScreen;
import core.ImageElement;
import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.GLabel;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.variables.OpticsVariables;
import pages.pioffice.PIOfficePage;
import parrot.Parrot;
import processing.core.PApplet;
import processing.core.PImage;

public class Monitors
extends ScreenElement {
    private String _mon_Onf;
    private String _mon_glowf;
    private String _glow_txt_figf;
    private String _sub_sys;
    private PImage mon_On;
    ImageElement screenGlow;
    GLabel txtGlow;
    boolean mouseHover;
    KeyFrameAnimation ScreenGlowPulsate;
    KeyFrameAnimation ScreenGlowOn;
    KeyFrameAnimation ScreenGlowOff;
    AudioPlayer On;
    AudioPlayer Off;

    public Monitors(ScreenElement screenElement, PApplet pApplet, String string, String string2, String string3, String string4, String string5) {
        super(screenElement, pApplet);
        this._mon_Onf = string;
        this._mon_glowf = string3;
        this._sub_sys = string4;
        this._glow_txt_figf = string5;
        this.screenGlow = new ImageElement(this._mon_glowf, this, pApplet);
        this.txtGlow = new GLabel(this, pApplet, string5, 0.5f, -0.1f, 0);
        this.addChild(this.screenGlow);
        this.addChild(this.txtGlow);
        this.setClickable(true);
    }

    @Override
    public void loadResources() {
        this.mon_On = ResourceManager.LoadImage(this._mon_Onf);
        this.setBounds(this.mon_On.width, this.mon_On.height);
        this.On = ResourceManager.LoadAudio("audio/69780__Antiphonal__Tv_switch_M48_beat_01.mp3");
        if (this.On != null) {
            this.On.setGain(-20.0f);
        }
        this.Off = ResourceManager.LoadAudio("audio/69781__Antiphonal__Tv_switch_M48_beat_01R.mp3");
        if (this.Off != null) {
            this.Off.setGain(-20.0f);
        }
    }

    @Override
    public void setup() {
        this._app.smooth();
        this.screenGlow.setOrigin(0.5f, 0.5f);
        this.screenGlow.setRelativePosition(0.5f, 0.34965035f);
        this.screenGlow.setVisible(false);
        this.ScreenGlowPulsate = new KeyFrameAnimation(true, this.screenGlow, new OnPulsateStop());
        this.ScreenGlowPulsate.AddKeyFrame(new PVectorKeyFrame(0.0f, 1.0f, 1.0f, TargetProperty.scale, EasingFunctions.EaseOut));
        this.ScreenGlowPulsate.AddKeyFrame(new PVectorKeyFrame(1.0f, 1.2f, 1.2f, TargetProperty.scale, EasingFunctions.EaseIn));
        this.ScreenGlowPulsate.AddKeyFrame(new PVectorKeyFrame(2.0f, 1.0f, 1.0f, TargetProperty.scale));
        this.ScreenGlowOn = new KeyFrameAnimation(false, this.screenGlow, new OnGlowOn());
        this.ScreenGlowOn.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity, EasingFunctions.EaseIn));
        this.ScreenGlowOn.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.ScreenGlowOff = new KeyFrameAnimation(false, this.screenGlow);
        this.ScreenGlowOff.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity, EasingFunctions.EaseOut));
        this.ScreenGlowOff.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
        this.txtGlow.setOrigin(0.5f, 0.5f);
        this.txtGlow.setVisible(false);
        this.txtGlow.setFont(Language.getString("Font_Handwritten"), 20);
        this.txtGlow.setColour(0.0f, 0.0f, 0.0f);
        this.txtGlow.setScale(0.8f, 0.8f);
    }

    @Override
    public void onMouseEvent(int n, int n2) {
        switch (n) {
            case 501: {
                break;
            }
            case 502: {
                if (this._sub_sys == "VibrationIsolation" && OpticsVariables.mirror_material == "") {
                    Parrot parrot = ((PIOfficePage)this.getParent())._parrot;
                    parrot.ShowExtraBubble(Language.getString("PIOffice_extra_buble"), 250, 120, true);
                    break;
                }
                GameScreen.showPage(this._sub_sys);
                break;
            }
            case 504: {
                this.mouseHover = true;
                this.screenGlow.setScale(1.0f, 1.0f);
                this.ScreenGlowOn.Start();
                this.screenGlow.setVisible(true);
                this.txtGlow.setVisible(true);
                if (this.On != null) {
                    this.On.cue(0);
                }
                if (this.On == null) break;
                this.On.play();
                break;
            }
            case 505: {
                this.mouseHover = false;
                this.ScreenGlowPulsate.Reset();
                this.ScreenGlowPulsate.Stop();
                this.screenGlow.setVisible(false);
                this.txtGlow.setVisible(false);
            }
        }
    }

    @Override
    public void render() {
        this._app.image(this.mon_On, 0.0f, 0.0f);
    }

    @Override
    public void update(float f) {
        if (this.mouseHover) {
            this.ScreenGlowOn.Update(f);
            this.ScreenGlowPulsate.Update(f);
            this.txtGlow.setVisible(true);
        } else {
            this.ScreenGlowOff.Update(f);
            this.txtGlow.setVisible(false);
        }
    }

    private class OnPulsateStop
    implements IAnimationCompleteCallback {
        private OnPulsateStop() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            Monitors.this.screenGlow.setScale(1.0f, 1.0f);
            Monitors.this.ScreenGlowOff.Start();
        }
    }

    private class OnGlowOn
    implements IAnimationCompleteCallback {
        private OnGlowOn() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            Monitors.this.ScreenGlowPulsate.Start();
        }
    }
}

