/*
 * Decompiled with CFR 0.152.
 */
package pages.pioffice.elements;

import core.ImageElement;
import core.ResourceManager;
import core.ScreenElement;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import processing.core.PApplet;
import processing.core.PImage;

public class Monitor
extends ScreenElement {
    PImage monitor_On;
    PImage imgDraw;
    ImageElement screenGlow;
    boolean mouseHover;
    KeyFrameAnimation ScreenGlowPulsate;
    KeyFrameAnimation ScreenGlowOn;
    KeyFrameAnimation ScreenGlowOff;

    public Monitor(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.screenGlow = new ImageElement("monitorA_glow.png", this, pApplet);
        this.addChild(this.screenGlow);
        this.setClickable(true);
    }

    @Override
    public void loadResources() {
        this.monitor_On = ResourceManager.LoadImage("monitorA_On.png");
        this.setBounds(this.monitor_On.width, this.monitor_On.height);
    }

    @Override
    public void setup() {
        this.screenGlow.setOrigin(0.5f, 0.5f);
        this.screenGlow.setRelativePosition(0.5f, 0.34965035f);
        this.screenGlow.setVisible(false);
        this.ScreenGlowPulsate = new KeyFrameAnimation(true, this.screenGlow, new OnPulsateStop());
        this.ScreenGlowPulsate.AddKeyFrame(new PVectorKeyFrame(0.0f, 1.0f, 1.0f, TargetProperty.scale, EasingFunctions.EaseOut));
        this.ScreenGlowPulsate.AddKeyFrame(new PVectorKeyFrame(1.0f, 1.2f, 1.2f, TargetProperty.scale, EasingFunctions.EaseIn));
        this.ScreenGlowPulsate.AddKeyFrame(new PVectorKeyFrame(2.0f, 1.0f, 1.0f, TargetProperty.scale));
        this.ScreenGlowOn = new KeyFrameAnimation(false, this.screenGlow, new OnGlowOn());
        this.ScreenGlowOn.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity, EasingFunctions.EaseIn));
        this.ScreenGlowOn.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.ScreenGlowOff = new KeyFrameAnimation(false, this.screenGlow);
        this.ScreenGlowOff.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity, EasingFunctions.EaseOut));
        this.ScreenGlowOff.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
    }

    public void onMouseEnter() {
        this.mouseHover = true;
        this.screenGlow.setScale(1.0f, 1.0f);
        this.ScreenGlowOn.Start();
        this.screenGlow.setVisible(true);
    }

    public void onMouseLeave() {
        this.mouseHover = false;
        this.ScreenGlowPulsate.Reset();
        this.ScreenGlowPulsate.Stop();
        this.screenGlow.setVisible(false);
    }

    @Override
    public void render() {
        this._app.image(this.monitor_On, 0.0f, 0.0f);
    }

    @Override
    public void update(float f) {
        if (this.mouseHover) {
            this.ScreenGlowOn.Update(f);
            this.ScreenGlowPulsate.Update(f);
        } else {
            this.ScreenGlowOff.Update(f);
        }
    }

    private class OnPulsateStop
    implements IAnimationCompleteCallback {
        private OnPulsateStop() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            Monitor.this.screenGlow.setScale(1.0f, 1.0f);
            Monitor.this.ScreenGlowOff.Start();
        }
    }

    private class OnGlowOn
    implements IAnimationCompleteCallback {
        private OnGlowOn() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            Monitor.this.ScreenGlowPulsate.Start();
        }
    }
}

