/*
 * Decompiled with CFR 0.152.
 */
package pages.pioffice.elements;

import core.ImageElement;
import core.ScreenElement;
import processing.core.PApplet;
import processing.core.PImage;

public class Clock
extends ImageElement {
    PImage clockface;
    float time;
    float rad;
    float T1;
    float T2;
    float xc;
    float yc;
    float htime;
    float stime;
    float mtime;
    float timeoff;

    public Clock(ScreenElement screenElement, PApplet pApplet) {
        super("clockfacesm.png", screenElement, pApplet);
    }

    @Override
    public void setup() {
        this.setOrigin(0.5f, 0.5f);
        this.setBounds(100, 92);
        this.rad = this.getHeight() / 3;
        this.xc = (float)this.getWidth() * 0.52f;
        this.yc = (float)this.getHeight() * 0.5f;
    }

    @Override
    public void update(float f) {
        this.time += 1.0f % this.T1;
        this.stime = 0.10471976f * (float)PApplet.second();
        this.mtime = 0.10471976f * (float)PApplet.minute();
        this.htime = 0.5235988f * ((float)PApplet.hour() % 12.0f) + this.mtime / 60.0f * 5.0f;
    }

    @Override
    public void render() {
        super.render();
        this._app.strokeWeight((float)this.getHeight() / 2.5f / 10.0f);
        this._app.line(this.xc, this.yc, this.xc + 0.8f * this.rad * PApplet.sin(this.htime), this.yc - 0.8f * this.rad * PApplet.cos(this.htime));
        this._app.strokeWeight((float)this.getHeight() / 3.0f / 10.0f);
        this._app.line(this.xc, this.yc, this.xc + this.rad * PApplet.sin(this.mtime), this.yc - this.rad * PApplet.cos(this.mtime));
        this._app.strokeWeight((float)this.getHeight() / 4.0f / 10.0f);
        this._app.line(this.xc, this.yc, this.xc + 1.1f * this.rad * PApplet.sin(this.stime), this.yc - 1.1f * this.rad * PApplet.cos(this.stime));
    }
}

