/*
 * Decompiled with CFR 0.152.
 */
package pages.pioffice;

import core.GamePage;
import core.GameScreen;
import core.ResourceManager;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.gui.ButtonElement;
import core.gui.GTextField;
import core.gui.GWSlider;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.PlayerData;
import game.variables.OpticsVariables;
import pages.pioffice.elements.Clock;
import pages.pioffice.elements.Monitors;
import pages.pioffice.elements.PInvestigator;
import pages.pioffice.elements.Phone;
import parrot.Parrot;
import processing.core.PApplet;
import processing.core.PImage;

public class PIOfficePage
extends GamePage {
    PImage backdrop;
    PImage keyboard;
    PImage window;
    PImage jungle;
    PImage island;
    PImage city;
    PImage desert;
    PImage boat;
    PImage monkey1;
    PImage monkey2;
    PImage poster1;
    PImage poster2;
    PImage statue;
    PImage jet;
    PImage jet2;
    PInvestigator piChair;
    Monitors monitorA;
    Monitors monitorB;
    Monitors monitorD;
    ButtonElement btn = new ButtonElement(this, this._app, "sciencebutton.png", "sciencebutton_hover.png", "sciencebutton_clicked.png");
    Clock clockface;
    Phone phone;
    GTextField txt;
    GWSlider sld;
    private float t0;
    private float dy1;
    private float dy2;
    public Parrot _parrot;
    boolean _piHidden = true;
    private AudioPlayer music;
    boolean running;

    public PIOfficePage(PApplet pApplet) {
        super(pApplet);
        this.piChair = new PInvestigator(this, this._app);
        this.monitorA = new Monitors(this, pApplet, "monitorA_On.png", "monitorA_Off.png", "monitorA_glow.png", "VibrationIsolation", Language.getString("Vibration") + " " + Language.getString("Isolation"));
        this.monitorB = new Monitors(this, pApplet, "monitorC_On.png", "monitorC_Off.png", "monitorC_glow.png", "EnvironmentSubsystem", Language.getString("Environment_sub"));
        this.monitorD = new Monitors(this, pApplet, "monitorD_On.png", "monitorC_Off.png", "monitorC_glow.png", "Optics", Language.getString("optics_sub"));
        this.clockface = new Clock(this, this._app);
        this.phone = new Phone(this, this._app);
        this._parrot = new Parrot(this, this._app);
        this.addChild(this.btn);
        this.addChild(this.monitorA);
        this.addChild(this.monitorB);
        this.addChild(this.monitorD);
        this.addChild(this.clockface);
        this.addChild(this.phone);
        this.addChild(this.piChair);
        this.addChild(this._parrot);
        this.running = false;
    }

    @Override
    public void loadResources() {
        this.backdrop = ResourceManager.LoadImage("PIofficeE.jpg");
        this.keyboard = ResourceManager.LoadImage("keyboardsm.png");
        this.window = ResourceManager.LoadImage("window.png");
        this.island = ResourceManager.LoadImage("islandwindow.png");
        this.boat = ResourceManager.LoadImage("islandboat.png");
        this.jungle = ResourceManager.LoadImage("junglewindow.png");
        this.city = ResourceManager.LoadImage("citywindow.png");
        this.desert = ResourceManager.LoadImage("desertwindow.png");
        this.monkey1 = ResourceManager.LoadImage("monkey1.png");
        this.monkey2 = ResourceManager.LoadImage("monkey2.png");
        this.poster1 = ResourceManager.LoadImage("ifoposter.png");
        this.poster2 = ResourceManager.LoadImage("amaldiposter.png");
        this.statue = ResourceManager.LoadImage("einsteinstatue.png");
        this.jet = ResourceManager.LoadImage("jet.png");
        this.jet2 = ResourceManager.LoadImage("jet2.png");
        this.music = ResourceManager.LoadAudio("audio/djlang59.mp3");
    }

    @Override
    public void setup() {
        this.setRelativePosition(0.0f, 1.0f);
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.3f, Float.valueOf(0.0f), TargetProperty.opacity));
        KeyFrameAnimation keyFrameAnimation2 = new KeyFrameAnimation(false, this);
        keyFrameAnimation2.AddKeyFrame(new PVectorKeyFrame(0.0f, 0.0f, 0.0f, TargetProperty.position));
        keyFrameAnimation2.AddKeyFrame(new PVectorKeyFrame(0.5f, 0.0f, 0.0f, TargetProperty.position));
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity));
        keyFrameAnimation2.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.setShowAnimation(keyFrameAnimation2);
        this.setHideAnimation(keyFrameAnimation);
        this.piChair.setRelativePosition(0.36666667f, 1.1666666f);
        this.monitorA.setRelativePosition(0.37222221f, 0.29166666f);
        this.monitorB.setRelativePosition(0.19444445f, 0.325f);
        this.monitorD.setRelativePosition(0.5555556f, 0.3f);
        this.clockface.setRelativePosition(0.072222225f, 0.145f);
        this.phone.setRelativePosition(0.7f, 0.48333332f);
        this.btn.setCallback(new SciBtnClick());
        this.btn.setRelativePosition(0.8888889f, 0.6666667f);
        this.btn.setOrigin(0.5f, 0.5f);
        this._parrot.ShowPerch(true);
        this._parrot.setRelativePosition(0.1f, 0.9f);
        this._parrot.SetText(Language.getString("PIOffice_parrot_1"), 320, 200, true);
    }

    @Override
    public void PreShow() {
        GameScreen.setChangeMusic(this.music, 2.0f, -10.0f);
    }

    @Override
    public void PostShow() {
        if (this._piHidden) {
            this.piChair.ShowPI.addCallback(new PIShowDone());
            this.piChair.ShowPI.Start();
            this._piHidden = false;
        }
        GameScreen.showHUD();
        if (this.IsFirstShow()) {
            this._parrot.ToggleBubble();
        } else if (this.running) {
            this.piChair.setRelativePosition(0.36666667f, 0.56666666f);
        }
    }

    @Override
    public void render() {
        this._app.smooth();
        this._app.image(this.backdrop, 0.0f, 0.0f);
        this._app.image(this.keyboard, 350.0f, 320.0f);
        this._app.image(this.poster1, 420.0f, 5.0f, (float)this.poster1.width * 1.0f, (float)this.poster1.height * 1.0f);
        this._app.image(this.poster2, 190.0f, 13.0f, (float)this.poster2.width * 1.0f, (float)this.poster2.height * 1.0f);
        this._app.imageMode(3);
        if (PlayerData.DetectorLocation == PlayerData.SiteLocations.DESERT) {
            this._app.image(this.desert, 770.0f, 120.0f, (float)this.window.width * 0.7f, (float)this.window.height * 0.7f);
        }
        if (PlayerData.DetectorLocation == PlayerData.SiteLocations.CITY) {
            this._app.image(this.city, 770.0f, 120.0f, (float)this.window.width * 0.7f, (float)this.window.height * 0.7f);
            if ((float)PApplet.second() == 0.0f) {
                this.t0 = this._app.millis();
                this.dy1 = this._app.random(-15.0f, 15.0f);
                this.dy2 = this._app.random(-20.0f, 20.0f);
            }
            if ((float)PApplet.second() > 0.0f & (float)PApplet.second() < 30.0f) {
                this._app.image(this.jet, 707.0f + (float)this.window.width * 0.65f * (((float)this._app.millis() - this.t0) % 30000.0f) / 30000.0f, 75.0f - this.dy1 + 2.0f * this.dy1 * (((float)this._app.millis() - this.t0) % 30000.0f) / 30000.0f, PApplet.max(this.dy2, 5.0f), PApplet.max(this.dy2, 5.0f));
            }
            if ((float)PApplet.second() == 40.0f) {
                this.t0 = this._app.millis();
                this.dy1 = this._app.random(-15.0f, 15.0f);
                this.dy2 = this._app.random(-20.0f, 20.0f);
            }
            if ((float)PApplet.second() > 40.0f & (float)PApplet.second() < 55.0f) {
                this._app.image(this.jet2, 707.0f + (float)this.window.width * 0.65f * (1.0f - ((float)this._app.millis() - this.t0) % 15000.0f / 15000.0f), 80.0f - 1.5f * this.dy1 + 0.7f * this.dy2 * (((float)(-this._app.millis()) + this.t0 + 40.0f) % 15000.0f) / 15000.0f, PApplet.max(this.dy1, 7.0f), PApplet.max(this.dy1, 7.0f));
            }
        }
        if (PlayerData.DetectorLocation == PlayerData.SiteLocations.JUNGLE) {
            this._app.image(this.jungle, 770.0f, 120.0f, (float)this.window.width * 0.7f, (float)this.window.height * 0.7f);
            this._app.imageMode(0);
            if ((float)PApplet.second() >= 0.0f & (float)PApplet.second() < 10.0f) {
                this._app.image(this.monkey1, 707.0f, 67.0f, (float)this.monkey1.width * 0.5f, (float)this.monkey1.height * 0.5f);
            }
            if ((float)PApplet.second() >= 10.0f & (float)PApplet.second() < 25.0f) {
                this._app.image(this.monkey2, 794.0f, 75.0f, (float)this.monkey2.width * 0.5f, (float)this.monkey2.height * 0.5f);
            }
            if ((float)PApplet.second() >= 25.0f & (float)PApplet.second() <= 35.0f) {
                this._app.image(this.monkey1, 794.0f, 79.0f, (float)this.monkey1.width * 0.5f, (float)this.monkey1.height * 0.5f);
            }
            if ((float)PApplet.second() > 35.0f & (float)PApplet.second() < 45.0f) {
                this._app.image(this.monkey1, 707.0f, 67.0f, (float)this.monkey1.width * 0.5f, (float)this.monkey1.height * 0.5f);
            }
            if ((float)PApplet.second() >= 45.0f & (float)PApplet.second() < 55.0f) {
                this._app.image(this.monkey2, 689.0f, 88.0f, (float)this.monkey2.width * 0.5f, (float)this.monkey2.height * 0.5f);
            }
            if ((float)PApplet.second() >= 55.0f & (float)PApplet.second() < 60.0f) {
                this._app.image(this.monkey1, 707.0f, 67.0f, (float)this.monkey1.width * 0.5f, (float)this.monkey1.height * 0.5f);
            }
            this._app.imageMode(3);
        }
        if (PlayerData.DetectorLocation == PlayerData.SiteLocations.ISLAND) {
            this._app.image(this.island, 770.0f, 120.0f, (float)this.window.width * 0.7f, (float)this.window.height * 0.7f);
            this._app.image(this.boat, 810.0f + 10.0f * PApplet.sin(0.1336848f * ((float)this._app.millis() / 1000.0f)), 138.0f + 11.0f * PApplet.sin(0.07222052f * ((float)this._app.millis() / 1000.0f)), (float)this.boat.width * 0.3f, (float)this.boat.height * 0.3f);
        }
        this._app.image(this.window, 770.0f, 120.0f, (float)this.window.width * 0.8f, (float)this.window.height * 0.8f);
        this._app.imageMode(0);
        this._app.image(this.statue, 80.0f, 185.0f, (float)this.statue.width * 0.5f, (float)this.statue.height * 0.5f);
    }

    public class PIShowDone
    implements IAnimationCompleteCallback {
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            PIOfficePage.this._piHidden = false;
            PIOfficePage.this.running = true;
            PIOfficePage.this.piChair.HidePI.removeCallback(new PIShowDone());
        }
    }

    public class PIHideDone
    implements IAnimationCompleteCallback {
        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            PIOfficePage.this._piHidden = true;
            PIOfficePage.this.piChair.HidePI.removeCallback(new PIHideDone());
            PIOfficePage.this.running = false;
            PIOfficePage.this.piChair.setRelativePosition(0.36666667f, 2.3333333f);
            GameScreen.showPage("ControlRoom");
        }
    }

    private class SciBtnClick
    implements ButtonElement.IButtonCallback {
        private SciBtnClick() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (!PIOfficePage.this.piChair.HidePI.isRunning()) {
                if (OpticsVariables.mirror_material == "") {
                    String string = Language.getString("PIOffice_parrot_2");
                    PIOfficePage.this._parrot.ShowExtraBubble(string, 250, 120, true);
                } else if (OpticsVariables.LaserPower == 0.0f) {
                    PIOfficePage.this._parrot.ShowExtraBubble(Language.getString("PIOffice_parrot_3"), 250, 120, true);
                } else if (PlayerData.getPlayerMoney() > 0L) {
                    PIOfficePage.this.piChair.HidePI.addCallback(new PIHideDone());
                    PIOfficePage.this.piChair.HidePI.Start();
                } else {
                    PIOfficePage.this._parrot.ShowExtraBubble(Language.getString("PIOffice_parrot_4"), 300, 100, true);
                }
            }
        }
    }
}

