/*
 * Decompiled with CFR 0.152.
 */
package pages.optics;

import core.ScreenElement;
import core.gui.GLabel;
import core.gui.GWSlider;
import core.gui.TextBlockElement;
import core.language.Language;
import game.variables.OpticsVariables;
import processing.core.PApplet;

public class OpticsSurfQ
extends ScreenElement {
    private GWSlider _sldSurfQ;
    private GLabel _title;
    private GLabel _cost;
    private TextBlockElement _Txt;

    public OpticsSurfQ(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setRelativeBounds(0.75f, 1.0f);
        this._Txt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Optics_Surf_text"), 18, 0.36f, 0.9f);
        this._title = new GLabel(this, pApplet, Language.getString("Optics_Surf_title"), 0.6f, 0.01f, (int)((float)this.getWidth() * 0.36f));
        this._cost = new GLabel(this, pApplet, Language.getString("Optics_Surf_cost") + ":", 0.95f, 0.67f, (int)((float)this.getWidth() * 0.35f));
        this._sldSurfQ = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.45f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.35f));
        this.addChild(this._sldSurfQ);
        this.addChild(this._Txt);
        this.addChild(this._title);
        this.addChild(this._cost);
    }

    @Override
    public void loadResources() {
    }

    @Override
    public void setup() {
        this._sldSurfQ.setRelativePosition(0.61f, 0.55f);
        this._sldSurfQ.setFontColour(255, 255, 255);
        this._sldSurfQ.setLimits(OpticsVariables.mirror_SurfQ, 1.0f, OpticsVariables.Maxmirror_SurfQ);
        this._sldSurfQ.setFont(Language.getString("Font_Default"), 17);
        this._sldSurfQ.setUnit("nm");
        this._sldSurfQ.setVisible(true);
        this._title.setFont(Language.getString("Font_Default"), 20);
        this._Txt.setRelativePosition(0.61f, 0.08f);
        this._cost.setOrigin(1.0f, 0.5f);
        this._cost.setFont(Language.getString("Font_Default"), 18);
        this._cost.setTextAlign(2);
    }

    public void reset() {
        this._sldSurfQ.setLimits(OpticsVariables.mirror_SurfQ, 1.0f, OpticsVariables.Maxmirror_SurfQ);
    }

    @Override
    public void update(float f) {
        OpticsVariables.mirror_SurfQ = this._sldSurfQ.getValuef();
        OpticsVariables.MirSurfQ_losses = -this._sldSurfQ.getValuef() / 499.0f * 0.9f + 1.0018036f;
    }

    public void PreHide() {
        this._app.unregisterMouseEvent(this._sldSurfQ);
    }

    @Override
    public void render() {
        this._cost.setText(Language.getString("Optics_Surf_cost") + ": " + this.FormatMoney(OpticsVariables.getSurfCosts()));
    }
}

