/*
 * Decompiled with CFR 0.152.
 */
package pages.optics;

import core.ImageElement;
import core.ScreenElement;
import core.gui.ButtonElement;
import core.gui.GLabel;
import core.gui.TextBlockElement;
import core.language.Language;
import game.variables.OpticsVariables;
import processing.core.PApplet;

public class OpticsMaterial
extends ScreenElement {
    private ImageElement _MirMatTick;
    private GLabel _title;
    private GLabel _cost;
    private GLabel _mat1;
    private GLabel _mat2;
    private GLabel _mat3;
    private GLabel _mat4;
    private TextBlockElement _Txt;
    private String titletext = Language.getString("Optics_Material_title");
    private ButtonElement MirMatBtn1;
    private ButtonElement MirMatBtn2;
    private ButtonElement MirMatBtn3;
    private ButtonElement MirMatBtn4;

    public OpticsMaterial(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setRelativeBounds(0.75f, 1.0f);
        this._Txt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Optics_Material_text"), 18, 0.36f, 0.9f);
        this._Txt.setRelativePosition(0.61f, 0.08f);
        this._title = new GLabel(this, pApplet, this.titletext, 0.6f, 0.01f, (int)((float)this.getWidth() * 0.36f));
        this._title.setFont(Language.getString("Font_Default"), 20);
        this._cost = new GLabel(this, pApplet, Language.getString("Optics_Material_cost") + ":", 0.95f, 0.43333334f, (int)((float)this.getWidth() * 0.35f));
        this._cost.setFont(Language.getString("Font_Default"), 18);
        this._cost.setOrigin(1.0f, 0.5f);
        this._cost.setTextAlign(2);
        this._mat1 = new GLabel(this, pApplet, Language.getString("Fused_Silica"), 0.7f, 0.73333335f, (int)((float)this.getWidth() * 0.2f));
        this._mat1.setOrigin(0.0f, 0.5f);
        this._mat1.setFont(Language.getString("Font_Default"), 18);
        this._mat1.setTextAlign(1);
        this._mat2 = new GLabel(this, pApplet, Language.getString("Silicon"), 0.7f, 0.6666667f, (int)((float)this.getWidth() * 0.2f));
        this._mat2.setOrigin(0.0f, 0.5f);
        this._mat2.setFont(Language.getString("Font_Default"), 18);
        this._mat2.setTextAlign(1);
        this._mat3 = new GLabel(this, pApplet, Language.getString("Glass"), 0.7f, 0.6f, (int)((float)this.getWidth() * 0.2f));
        this._mat3.setOrigin(0.0f, 0.5f);
        this._mat3.setFont(Language.getString("Font_Default"), 18);
        this._mat3.setTextAlign(1);
        this._mat4 = new GLabel(this, pApplet, Language.getString("Sapphire"), 0.7f, 0.53333336f, (int)((float)this.getWidth() * 0.2f));
        this._mat4.setOrigin(0.0f, 0.5f);
        this._mat4.setFont(Language.getString("Font_Default"), 18);
        this._mat4.setTextAlign(1);
        this.MirMatBtn1 = new ButtonElement(this, this._app, "tickbox.png", "tickbox.png", "tickbox.png");
        this.MirMatBtn2 = new ButtonElement(this, this._app, "tickbox.png", "tickbox.png", "tickbox.png");
        this.MirMatBtn3 = new ButtonElement(this, this._app, "tickbox.png", "tickbox.png", "tickbox.png");
        this.MirMatBtn4 = new ButtonElement(this, this._app, "tickbox.png", "tickbox.png", "tickbox.png");
        this._MirMatTick = new ImageElement("tick.png", this, pApplet);
        this.addChild(this.MirMatBtn1);
        this.addChild(this.MirMatBtn2);
        this.addChild(this.MirMatBtn3);
        this.addChild(this.MirMatBtn4);
        this.addChild(this._mat1);
        this.addChild(this._mat2);
        this.addChild(this._mat3);
        this.addChild(this._mat4);
        this.addChild(this._Txt);
        this.addChild(this._title);
        this.addChild(this._cost);
        this.addChild(this._MirMatTick);
    }

    @Override
    public void setup() {
        this.MirMatBtn1.setCallback(new MirIconClicked());
        this.MirMatBtn1.setRelativePosition(0.6666667f, 0.73333335f);
        this.MirMatBtn1.setOrigin(0.5f, 0.5f);
        this.MirMatBtn1.setVisible(true);
        this.MirMatBtn1.setScale(0.3f, 0.3f);
        this.MirMatBtn2.setCallback(new MirIconClicked());
        this.MirMatBtn2.setRelativePosition(0.6666667f, 0.6666667f);
        this.MirMatBtn2.setOrigin(0.5f, 0.5f);
        this.MirMatBtn2.setVisible(true);
        this.MirMatBtn2.setScale(0.3f, 0.3f);
        this.MirMatBtn3.setCallback(new MirIconClicked());
        this.MirMatBtn3.setRelativePosition(0.6666667f, 0.6f);
        this.MirMatBtn3.setOrigin(0.5f, 0.5f);
        this.MirMatBtn3.setVisible(true);
        this.MirMatBtn3.setScale(0.3f, 0.3f);
        this.MirMatBtn4.setCallback(new MirIconClicked());
        this.MirMatBtn4.setRelativePosition(0.6666667f, 0.53333336f);
        this.MirMatBtn4.setOrigin(0.5f, 0.5f);
        this.MirMatBtn4.setVisible(true);
        this.MirMatBtn4.setScale(0.3f, 0.3f);
        this._MirMatTick.setRelativePosition(1.1111112f, 0.6f);
        this._MirMatTick.setOrigin(0.5f, 0.5f);
        this._MirMatTick.setVisible(true);
        this._MirMatTick.setScale(0.3f, 0.3f);
    }

    public void reset() {
        this._MirMatTick.setRelativePosition(1.1111112f, 0.6f);
    }

    @Override
    public void update(float f) {
        this._cost.setText(Language.getString("Optics_Material_cost") + ": " + this.FormatMoney(OpticsVariables.getMirMatCosts()));
    }

    @Override
    public void render() {
    }

    private class MirIconClicked
    implements ButtonElement.IButtonCallback {
        private MirIconClicked() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (n == 37) {
                if (buttonElement == OpticsMaterial.this.MirMatBtn1) {
                    OpticsVariables.mirror_material = Language.getString("Fused_Silica");
                    OpticsMaterial.this._MirMatTick.setRelativePosition(0.6666667f, 0.73333335f);
                    OpticsVariables.MirMat_losses = 1.0;
                } else if (buttonElement == OpticsMaterial.this.MirMatBtn2) {
                    OpticsVariables.mirror_material = Language.getString("Silicon");
                    OpticsMaterial.this._MirMatTick.setRelativePosition(0.6666667f, 0.6666667f);
                    OpticsVariables.MirMat_losses = 1.0;
                } else if (buttonElement == OpticsMaterial.this.MirMatBtn3) {
                    OpticsVariables.mirror_material = Language.getString("Glass");
                    OpticsMaterial.this._MirMatTick.setRelativePosition(0.6666667f, 0.6f);
                    OpticsVariables.MirMat_losses = 0.4;
                } else if (buttonElement == OpticsMaterial.this.MirMatBtn4) {
                    OpticsVariables.mirror_material = Language.getString("Sapphire");
                    OpticsMaterial.this._MirMatTick.setRelativePosition(0.6666667f, 0.53333336f);
                    OpticsVariables.MirMat_losses = 1.0;
                }
            }
        }
    }
}

