/*
 * Decompiled with CFR 0.152.
 */
package pages.optics;

import core.ScreenElement;
import core.gui.GLabel;
import core.gui.GWSlider;
import core.gui.TextBlockElement;
import core.language.Language;
import game.variables.OpticsVariables;
import processing.core.PApplet;

public class OpticsLaser
extends ScreenElement {
    private GWSlider _sldPower;
    private GLabel _title;
    private GLabel _cost;
    private TextBlockElement _Txt;

    public OpticsLaser(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this._app = pApplet;
        this.setRelativeBounds(0.75f, 1.0f);
        this._Txt = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), Language.getString("Optics_Laser_text"), 18, 0.36f, 0.9f);
        this._title = new GLabel(this, pApplet, Language.getString("Optics_Laser_title"), 0.6f, 0.01f, (int)((float)this.getWidth() * 0.36f));
        this._cost = new GLabel(this, pApplet, Language.getString("Optics_Laser_cost") + ":", 0.95f, 0.67f, this.getWidth());
        this._sldPower = new GWSlider(this, pApplet, (int)((float)this.getWidth() * 0.45f), (int)((float)this.getHeight() * 0.5f), (int)((float)this.getWidth() * 0.35f));
        this.addChild(this._Txt);
        this.addChild(this._title);
        this.addChild(this._cost);
        this.addChild(this._sldPower);
    }

    public void reset() {
        this._sldPower.setLimits(OpticsVariables.LaserPower, 0.0f, OpticsVariables.MaxLaserPower);
    }

    @Override
    public void setup() {
        this._sldPower.setRelativePosition(0.61f, 0.55f);
        this._sldPower.setLimits(OpticsVariables.LaserPower, 0.0f, OpticsVariables.MaxLaserPower);
        this._sldPower.setFontColour(255, 255, 255);
        this._sldPower.setFont(Language.getString("Font_Default"), 17);
        this._sldPower.setUnit("W");
        this._Txt.setRelativePosition(0.61f, 0.08f);
        this._title.setFont(Language.getString("Font_Default"), 20);
        this._cost.setOrigin(1.0f, 0.5f);
        this._cost.setFont(Language.getString("Font_Default"), 18);
        this._cost.setTextAlign(2);
    }

    @Override
    public void update(float f) {
        OpticsVariables.LaserPower = this._sldPower.getValuef();
    }

    @Override
    public void render() {
        this._cost.setText(Language.getString("Optics_Laser_cost") + ": " + this.FormatMoney(OpticsVariables.getLaserCosts()));
    }
}

