/*
 * Decompiled with CFR 0.152.
 */
package pages.optics;

import core.ImageElement;
import core.ResourceManager;
import core.ScreenElement;
import core.language.Language;
import game.variables.OpticsVariables;
import processing.core.PApplet;
import processing.core.PImage;

public class OpticsDisplay
extends ScreenElement {
    private ImageElement _laser;
    private PImage _Plaser;
    private PImage _Pred;
    private PImage _Pmir1;
    private PImage _Pmir2;
    private PImage _Pmir3;
    private PImage _Pmir4;
    private float lsc;
    private float Qsc;

    public OpticsDisplay(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this.setRelativeBounds(0.75f, 1.0f);
        this._laser = new ImageElement("laserbox_loading.png", this, pApplet);
        this._laser.loadResources();
        this._laser.setOrigin(0.185f, 0.63975155f);
        this._laser.setRelativePosition(0.33333334f, 0.5f);
    }

    @Override
    public void loadResources() {
        this._Plaser = ResourceManager.LoadImage("laserbox_loading.png");
        this._Pred = ResourceManager.LoadImage("red.png");
        this._Pmir1 = ResourceManager.LoadImage("mirrorsilica.png");
        this._Pmir2 = ResourceManager.LoadImage("mirrorsilicon.png");
        this._Pmir3 = ResourceManager.LoadImage("mirrorglass.png");
        this._Pmir4 = ResourceManager.LoadImage("mirrorsapphire.png");
    }

    @Override
    public void render() {
        this.lsc = (float)Math.sqrt(OpticsVariables.LaserPower / OpticsVariables.MaxLaserPower) * this.getAbsoluteOpacity();
        this.Qsc = OpticsVariables.mirror_SurfQ / OpticsVariables.Maxmirror_SurfQ;
        this._app.image(this._Plaser, 192.0f, 40.0f, (float)this._Plaser.width * 0.7f, (float)this._Plaser.height * 0.7f);
        this._app.imageMode(3);
        this._app.pushMatrix();
        this._app.scale(-1.0f, 1.0f);
        if (OpticsVariables.mirror_material == Language.getString("Fused_Silica")) {
            this._app.image(this._Pmir1, -94.0f, 150.0f, 75.0f, 78.0f);
        } else if (OpticsVariables.mirror_material == Language.getString("Silicon")) {
            this._app.image(this._Pmir2, -94.0f, 150.0f, 75.0f, 78.0f);
        } else if (OpticsVariables.mirror_material == Language.getString("Glass")) {
            this._app.image(this._Pmir3, -94.0f, 150.0f, 75.0f, 78.0f);
        } else if (OpticsVariables.mirror_material == Language.getString("Sapphire")) {
            this._app.image(this._Pmir4, -94.0f, 150.0f, 75.0f, 78.0f);
        }
        this._app.popMatrix();
        if ((double)this.getAbsoluteOpacity() > 0.99 && OpticsVariables.mirror_material != "" && OpticsVariables.LaserPower > 0.0f) {
            this._app.imageMode(0);
            this._app.pushStyle();
            this._app.translate(0.0f, 0.0f, 0.001f);
            this._app.strokeWeight(1.0f + 2.0f * this.lsc);
            this._app.stroke(255.0f, 0.0f, 0.0f, this.lsc * 250.0f);
            this._app.strokeCap(2);
            this._app.line(218.0f, 111.0f, 100.0f, 150.0f);
            this._app.popStyle();
            this._app.pushStyle();
            this._app.imageMode(3);
            this._app.tint(255.0f, this.lsc * 250.0f);
            this._app.image(this._Pred, 217.0f, 111.0f, 30.0f * this.lsc, 30.0f * this.lsc);
            this._app.popStyle();
            this._app.pushStyle();
            this._app.translate(0.0f, 0.0f, 0.001f);
            this._app.fill(255.0f, 0.0f, 0.0f, 250.0f * this.lsc * (1.2f - this.Qsc) / 1.2f);
            this._app.stroke(255.0f, 0.0f, 0.0f, (100.0f + 155.0f * this.lsc) * (1.2f - this.Qsc) / 1.2f);
            this._app.quad(102.0f + 0.3f * this.lsc / 2.0f, 148.0f, 102.0f - 0.3f * this.lsc / 2.0f, 148.0f, 102.0f - 0.3f * this.lsc / 2.0f - 180.0f * this.Qsc + 190.0f, 610.0f, 102.0f + 0.3f * this.lsc / 2.0f + 120.0f * this.Qsc + 190.0f, 610.0f);
            this._app.popStyle();
            this._app.pushStyle();
            this._app.imageMode(3);
            this._app.tint(255.0f, this.lsc * 200.0f);
            this._app.image(this._Pred, 102.0f, 150.0f, 40.0f * this.lsc, 40.0f * this.lsc);
            this._app.popStyle();
        }
        super.render();
    }
}

