/*
 * Decompiled with CFR 0.152.
 */
package pages.gamesetup.elements;

import core.ResourceManager;
import core.ScreenElement;
import processing.core.PApplet;
import processing.core.PImage;

public class LocationStars
extends ScreenElement {
    private int _totalStars = 5;
    private int _starsShowing = 2;
    private PImage _starOff;
    private PImage _starOn;
    private final int _spacing = 5;

    public LocationStars(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
    }

    @Override
    public void loadResources() {
        this._starOff = ResourceManager.LoadImage("starOff.png");
        this._starOn = ResourceManager.LoadImage("starOn.png");
    }

    public void setStars(int n) {
        if (n < 0 || n > this._totalStars) {
            throw new RuntimeException("Stars shown must be between 0 and " + this._totalStars);
        }
        this._starsShowing = n;
    }

    @Override
    public void render() {
        for (int i = 1; i <= this._totalStars; ++i) {
            if (i > this._starsShowing) {
                this._app.image(this._starOff, this._starOff.width * (i - 1) + 5, 0.0f);
                continue;
            }
            this._app.image(this._starOn, this._starOn.width * (i - 1) + 5, 0.0f);
        }
    }
}

