/*
 * Decompiled with CFR 0.152.
 */
package pages.gamesetup.elements;

import core.ScreenElement;
import core.gui.FrameElement;
import core.gui.GLabel;
import core.gui.TextBlockElement;
import core.gui.TextButtonElement;
import core.language.Language;
import game.detectorsites.CitySite;
import game.detectorsites.IDetectorSite;
import org.gwoptics.graphics.GWColour;
import pages.gamesetup.elements.LocationStars;
import processing.core.PApplet;

public class LocationInfoFrame
extends ScreenElement {
    private FrameElement _frm;
    private LocationStars _noisestars;
    private LocationStars _budgetstars;
    private LocationStars _infrastars;
    private TextBlockElement _txtDesc;
    private GLabel _lblLocName;
    public TextButtonElement btnNext;

    public LocationInfoFrame(ScreenElement screenElement, PApplet pApplet) {
        super(screenElement, pApplet);
        this._frm = new FrameElement(this, pApplet);
        this._frm.setRelativeBounds(1.0f, 1.0f);
        this._noisestars = new LocationStars(this, pApplet);
        this._budgetstars = new LocationStars(this, pApplet);
        this._infrastars = new LocationStars(this, pApplet);
        this._txtDesc = new TextBlockElement(this, pApplet, Language.getString("Font_Default"), "", 16, 0.96f, 0.6f);
        this._txtDesc.setMargin(10);
        this._txtDesc.setRelativePosition(0.02f, 0.1f);
        this.btnNext = new TextButtonElement(this, pApplet, "buttons/donebutton.png", "buttons/donebuttonpressed.png", "buttons/donebuttonpressed.png", "audio/Tiny Button Push-SoundBible.com-513260752.mp3", Language.getString("Next"));
        this.addChild(this._frm);
        this.addChild(this._noisestars);
        this.addChild(this._budgetstars);
        this.addChild(this._infrastars);
        this.addChild(this._txtDesc);
        this.addChild(this.btnNext);
    }

    @Override
    public void setup() {
        this.btnNext.setTextColours(new GWColour(0, 0, 0), null, null);
        this.btnNext.setFont(Language.getString("Font_Handwritten"), 20);
        this.btnNext.setOrigin(0.5f, 1.0f);
        this.btnNext.setRelativePosition(0.5f, 0.99f);
        GLabel gLabel = new GLabel(this, this._app, Language.getString("EnterNamePage_noise") + ":", 0.02f, 0.59f, (int)(0.5f * (float)this.getWidth()));
        gLabel.setFont(Language.getString("Font_Default"), 22);
        this.addChild(gLabel);
        this._noisestars.setRelativePosition(0.4f, 0.58f);
        gLabel = new GLabel(this, this._app, Language.getString("EnterNamePage_budget") + ":", 0.02f, 0.69f, (int)(0.5f * (float)this.getWidth()));
        gLabel.setFont(Language.getString("Font_Default"), 22);
        this.addChild(gLabel);
        this._budgetstars.setRelativePosition(0.4f, 0.68f);
        gLabel = new GLabel(this, this._app, Language.getString("EnterNamePage_support") + ":", 0.02f, 0.79f, (int)(0.5f * (float)this.getWidth()));
        gLabel.setFont(Language.getString("Font_Default"), 22);
        this.addChild(gLabel);
        this._infrastars.setRelativePosition(0.4f, 0.78f);
        this._lblLocName = new GLabel(this, this._app, "", 0.02f, 0.02f, (int)(0.96f * (float)this.getWidth()));
        this._lblLocName.setFont(Language.getString("Font_Default"), 30);
        this.addChild(this._lblLocName);
        this.setDetectorSiteInfo(new CitySite());
    }

    public void setDetectorSiteInfo(IDetectorSite iDetectorSite) {
        this._noisestars.setStars(iDetectorSite.getNoiseRating());
        this._budgetstars.setStars(iDetectorSite.getBudgetRating());
        this._infrastars.setStars(iDetectorSite.getSupportRating());
        this._lblLocName.setText(iDetectorSite.getName());
        this._txtDesc.setText(iDetectorSite.getDescription());
    }
}

