/*
 * Decompiled with CFR 0.152.
 */
package pages.gamesetup.elements;

import core.ImageElement;
import core.ScreenElement;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.FrameElement;
import game.PlayerData;
import game.detectorsites.CitySite;
import game.detectorsites.DesertSite;
import game.detectorsites.IslandSite;
import game.detectorsites.JungleSite;
import pages.gamesetup.elements.LocationInfoFrame;
import processing.core.PApplet;

public class DetectorMap
extends ScreenElement {
    private ImageElement _map;
    private ButtonElement _city;
    private ButtonElement _monkey;
    private ButtonElement _island;
    private ButtonElement _camel;
    private FrameElement _frm;
    private LocationInfoFrame _locInfo;

    public DetectorMap(ScreenElement screenElement, PApplet pApplet, LocationInfoFrame locationInfoFrame) {
        super(screenElement, pApplet);
        this._locInfo = locationInfoFrame;
        this._map = new ImageElement("detectormap/map.png", this, this._app);
        this._frm = new FrameElement(this, pApplet);
        this._city = new ButtonElement(this, pApplet, "detectormap/city.png", "detectormap/city.png", "detectormap/city.png", "audio/Tiny Button Push-SoundBible.com-513260752.mp3");
        this._monkey = new ButtonElement(this, pApplet, "detectormap/monkey.png", "detectormap/monkey.png", "detectormap/monkey.png", "audio/Tiny Button Push-SoundBible.com-513260752.mp3");
        this._island = new ButtonElement(this, pApplet, "detectormap/palmtree.png", "detectormap/palmtree.png", "detectormap/palmtree.png", "audio/Tiny Button Push-SoundBible.com-513260752.mp3");
        this._camel = new ButtonElement(this, pApplet, "detectormap/camel.png", "detectormap/camel.png", "detectormap/camel.png", "audio/Tiny Button Push-SoundBible.com-513260752.mp3");
        this.addChild(this._frm);
        this.addChild(this._map);
        this.addChild(this._city);
        this.addChild(this._monkey);
        this.addChild(this._island);
        this.addChild(this._camel);
    }

    @Override
    public void loadResources() {
        this.setBounds(this._map.getWidth(), this._map.getHeight());
        this._frm.setBounds(this._map.getWidth(), this._map.getHeight());
    }

    @Override
    public void setup() {
        this._city.setOrigin(0.5f, 0.5f);
        this._monkey.setOrigin(0.5f, 0.5f);
        this._island.setOrigin(0.5f, 0.5f);
        this._camel.setOrigin(0.5f, 0.5f);
        this._city.setRelativePosition(0.29182878f, 0.2624672f);
        this._monkey.setRelativePosition(0.35992217f, 0.5249344f);
        this._island.setRelativePosition(0.88521403f, 0.42257217f);
        this._camel.setRelativePosition(0.54474705f, 0.6666667f);
        this._city.setCallback(new ButtonClicked());
        this._monkey.setCallback(new ButtonClicked());
        this._island.setCallback(new ButtonClicked());
        this._camel.setCallback(new ButtonClicked());
        float f = 0.5235988f;
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation();
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.rotation, EasingFunctions.EaseOut));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.3f, Float.valueOf(f), TargetProperty.rotation, EasingFunctions.EaseIn));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.6f, Float.valueOf(0.0f), TargetProperty.rotation, EasingFunctions.EaseOut));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.9f, Float.valueOf(-f), TargetProperty.rotation, EasingFunctions.EaseIn));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(1.2f, Float.valueOf(0.0f), TargetProperty.rotation));
        KeyFrameAnimation keyFrameAnimation2 = keyFrameAnimation.duplicate(false, false);
        keyFrameAnimation2.AddTargetObject(this._city);
        this._city.setHoverAnimation(keyFrameAnimation2);
        keyFrameAnimation2 = keyFrameAnimation.duplicate(false, false);
        keyFrameAnimation2.AddTargetObject(this._monkey);
        this._monkey.setHoverAnimation(keyFrameAnimation2);
        keyFrameAnimation2 = keyFrameAnimation.duplicate(false, false);
        keyFrameAnimation2.AddTargetObject(this._island);
        this._island.setHoverAnimation(keyFrameAnimation2);
        keyFrameAnimation2 = keyFrameAnimation.duplicate(false, false);
        keyFrameAnimation2.AddTargetObject(this._camel);
        this._camel.setHoverAnimation(keyFrameAnimation2);
        PlayerData.DetectorLocation = PlayerData.SiteLocations.CITY;
    }

    private class ButtonClicked
    implements ButtonElement.IButtonCallback {
        private ButtonClicked() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (buttonElement == DetectorMap.this._monkey) {
                PlayerData.DetectorLocation = PlayerData.SiteLocations.JUNGLE;
                DetectorMap.this._locInfo.setDetectorSiteInfo(new JungleSite());
                PlayerData.InitialPlayerMoney = 125000000L;
                PlayerData.DetectorSite = new JungleSite();
            } else if (buttonElement == DetectorMap.this._city) {
                PlayerData.DetectorLocation = PlayerData.SiteLocations.CITY;
                DetectorMap.this._locInfo.setDetectorSiteInfo(new CitySite());
                PlayerData.InitialPlayerMoney = 75000000L;
                PlayerData.DetectorSite = new CitySite();
            } else if (buttonElement == DetectorMap.this._island) {
                PlayerData.DetectorLocation = PlayerData.SiteLocations.ISLAND;
                DetectorMap.this._locInfo.setDetectorSiteInfo(new IslandSite());
                PlayerData.InitialPlayerMoney = 115000000L;
                PlayerData.DetectorSite = new IslandSite();
            } else if (buttonElement == DetectorMap.this._camel) {
                PlayerData.DetectorLocation = PlayerData.SiteLocations.DESERT;
                DetectorMap.this._locInfo.setDetectorSiteInfo(new DesertSite());
                PlayerData.InitialPlayerMoney = 75000000L;
                PlayerData.DetectorSite = new DesertSite();
            }
        }
    }
}

