/*
 * Decompiled with CFR 0.152.
 */
package pages.gamesetup;

import core.GamePage;
import core.GameScreen;
import core.ResourceManager;
import core.animation.IAnimationCompleteCallback;
import core.animation.KeyFrameAnimation;
import core.animation.TargetProperty;
import core.animation.keyframes.FloatKeyFrame;
import core.animation.keyframes.PVectorKeyFrame;
import core.animation.keyframes.easing.EasingFunctions;
import core.gui.ButtonElement;
import core.gui.GLabel;
import core.gui.GTextField;
import core.gui.TextButtonElement;
import core.language.Language;
import ddf.minim.AudioPlayer;
import game.PlayerData;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import org.gwoptics.graphics.GWColour;
import pages.gamesetup.elements.DetectorMap;
import pages.gamesetup.elements.LocationInfoFrame;
import parrot.Parrot;
import processing.core.PApplet;
import processing.core.PImage;

public class EnterNamePage
extends GamePage {
    GTextField txtPlayerName;
    GTextField txtDetectorName;
    GLabel lblPlayerName;
    GLabel lblDetectorName;
    PImage imgBack;
    TextButtonElement btnNext;
    KeyFrameAnimation hideEnterNameBoxes;
    KeyFrameAnimation hideEnterNameLbls;
    KeyFrameAnimation showDetectorLocs;
    DetectorMap _map;
    LocationInfoFrame _locFrm;
    boolean _enteredNamed = false;
    GLabel _pageTitle;
    Parrot _parrot;
    AudioPlayer music;

    public EnterNamePage(PApplet pApplet) {
        super(pApplet);
        this.btnNext = new TextButtonElement(this, pApplet, "buttons/donebutton.png", "buttons/donebuttonpressed.png", "buttons/donebuttonpressed.png", "audio/Tiny Button Push-SoundBible.com-513260752.mp3", Language.getString("Next"));
        this._locFrm = new LocationInfoFrame(this, pApplet);
        this._map = new DetectorMap(this, pApplet, this._locFrm);
        this._parrot = new Parrot(this, pApplet);
        this.addChild(this.btnNext);
        this.addChild(this._map);
        this.addChild(this._locFrm);
        this.addChild(this._parrot);
    }

    @Override
    public void loadResources() {
        this.imgBack = ResourceManager.LoadImage("EnterScreenBack.jpg");
        this.music = ResourceManager.LoadAudio("audio/djlang59.mp3");
    }

    @Override
    public void setup() {
        this.setRelativePosition(0.0f, 0.0f);
        KeyFrameAnimation keyFrameAnimation = new KeyFrameAnimation(false, this);
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(1.0f), TargetProperty.opacity));
        keyFrameAnimation.AddKeyFrame(new FloatKeyFrame(0.5f, Float.valueOf(0.0f), TargetProperty.opacity));
        KeyFrameAnimation keyFrameAnimation2 = new KeyFrameAnimation(false, this);
        this.setShowAnimation(keyFrameAnimation2);
        this.setHideAnimation(keyFrameAnimation);
        this._parrot.setRelativePosition(0.1f, 1.0f);
        this._parrot.SetText(Language.getString("EnterNamePage_parrot_1"), 300, 210, true);
        this.btnNext.setTextColours(new GWColour(0, 0, 0), null, null);
        this.btnNext.setFont(Language.getString("Font_Handwritten"), 20);
        this.btnNext.setOrigin(0.5f, 0.5f);
        this.btnNext.setRelativePosition(0.5f, 0.9f);
        this.btnNext.setCallback(new NextButtonClick());
        this.txtPlayerName = new GTextField(this, this._app, "", 0.5f, 0.26666668f, (int)(0.44444445f * (float)this._app.width), 20);
        this.txtPlayerName.setFont(Language.getString("Font_Default"), 35);
        this.txtPlayerName.setTextAlign(4);
        this.txtPlayerName.setText(Language.getString("EnterNamePage_Name"));
        this.lblPlayerName = new GLabel(this, this._app, Language.getString("EnterNamePage_label_1"), 0.5f, 0.13333334f, (int)(0.22222222f * (float)this._app.width));
        this.lblPlayerName.setFont(Language.getString("Font_Default"), 35);
        this.lblPlayerName.setTextAlign(4);
        this.txtDetectorName = new GTextField(this, this._app, "", 0.5f, 0.6f, (int)(0.44444445f * (float)this._app.width), 20);
        this.txtDetectorName.setFont(Language.getString("Font_Default"), 35);
        this.txtDetectorName.setTextAlign(4);
        this.txtDetectorName.setText(Language.getString("EnterNamePage_Detector"));
        this.lblDetectorName = new GLabel(this, this._app, Language.getString("EnterNamePage_label_2"), 0.5f, 0.46666667f, (int)(0.22222222f * (float)this._app.width));
        this.lblDetectorName.setTextAlign(4);
        this.lblDetectorName.setFont(Language.getString("Font_Default"), 35);
        this.txtPlayerName.setOrigin(0.5f, 0.5f);
        this.lblPlayerName.setOrigin(0.5f, 0.5f);
        this.txtDetectorName.setOrigin(0.5f, 0.5f);
        this.lblDetectorName.setOrigin(0.5f, 0.5f);
        this.hideEnterNameBoxes = new KeyFrameAnimation(false);
        this.hideEnterNameBoxes.AddKeyFrame(new PVectorKeyFrame(0.0f, 0.5f * (float)this._app.width, Float.NaN, TargetProperty.position, EasingFunctions.EaseInOut));
        this.hideEnterNameBoxes.AddKeyFrame(new PVectorKeyFrame(2.0f, -300.0f, Float.NaN, TargetProperty.position));
        this.hideEnterNameLbls = new KeyFrameAnimation(false);
        this.hideEnterNameLbls.addCallback(new HideEnterDetails());
        this.hideEnterNameLbls.AddKeyFrame(new PVectorKeyFrame(0.0f, Float.NaN, Float.NaN, TargetProperty.position));
        this.hideEnterNameLbls.AddKeyFrame(new PVectorKeyFrame(0.2f, 0.5f * (float)this._app.width, Float.NaN, TargetProperty.position, EasingFunctions.EaseInOut));
        this.hideEnterNameLbls.AddKeyFrame(new PVectorKeyFrame(2.2f, -300.0f, Float.NaN, TargetProperty.position));
        this.hideEnterNameBoxes.AddTargetObject(this.txtPlayerName);
        this.hideEnterNameBoxes.AddTargetObject(this.txtDetectorName);
        this.hideEnterNameBoxes.AddTargetObject(this.btnNext);
        this.hideEnterNameLbls.AddTargetObject(this.lblPlayerName);
        this.hideEnterNameLbls.AddTargetObject(this.lblDetectorName);
        this._pageTitle = new GLabel(this, this._app, Language.getString("EnterNamePage_label_3"), 0.02f, 0.02f, 400);
        this._pageTitle.setVisible(false);
        this._pageTitle.setFont(Language.getString("Font_Default"), 45);
        this._map.setRelativePosition(0.02f, 0.5f);
        this._map.setVisible(false);
        this._locFrm.setRelativePosition(0.6f, 0.5f);
        this._locFrm.setVisible(false);
        this._locFrm.setBounds((int)(0.38f * (float)this.getWidth()), (int)(0.95f * (float)this.getHeight()));
        this._locFrm.btnNext.setCallback(new NextButtonClick());
        this.showDetectorLocs = new KeyFrameAnimation();
        this.showDetectorLocs.AddKeyFrame(new FloatKeyFrame(0.0f, Float.valueOf(0.0f), TargetProperty.opacity, EasingFunctions.EaseOut));
        this.showDetectorLocs.AddKeyFrame(new FloatKeyFrame(1.5f, Float.valueOf(1.0f), TargetProperty.opacity));
        this.showDetectorLocs.AddTargetObject(this._map);
        this.showDetectorLocs.AddTargetObject(this._locFrm);
        this.showDetectorLocs.AddTargetObject(this._pageTitle);
        this.addChild(this._pageTitle);
        this.addChild(this.txtDetectorName);
        this.addChild(this.txtPlayerName);
        this.addChild(this.lblDetectorName);
        this.addChild(this.lblPlayerName);
        this.changeChildZIndex(this._parrot, 100);
    }

    @Override
    public void PreShow() {
        GameScreen.reset();
        GameScreen.setChangeMusic(this.music, 3.0f, -10.0f);
        this._enteredNamed = false;
        this.btnNext.setRelativePosition(0.5f, 0.9f);
        this.txtPlayerName.setRelativePosition(0.5f, 0.26666668f);
        this.lblPlayerName.setRelativePosition(0.5f, 0.13333334f);
        this.txtDetectorName.setRelativePosition(0.5f, 0.6f);
        this.lblDetectorName.setRelativePosition(0.5f, 0.46666667f);
        this._pageTitle = new GLabel(this, this._app, Language.getString("EnterNamePage_label_3"), 0.02f, 0.02f, 400);
        this._pageTitle.setVisible(false);
        this._pageTitle.setFont(Language.getString("Font_Default"), 45);
        this._map.setRelativePosition(0.02f, 0.12f);
        this._map.setVisible(false);
        this._locFrm.setRelativePosition(0.6f, 0.12f);
        this._locFrm.setVisible(false);
        this._locFrm.setBounds((int)(0.38f * (float)this.getWidth()), (int)(0.85f * (float)this.getHeight()));
        this._locFrm.btnNext.setCallback(new NextButtonClick());
        this.setOpacity(1.0f);
        GameScreen.hideHUD();
        GComponent.globalColor = GCScheme.getColor(this._app, 1);
    }

    @Override
    public void PostShow() {
        if (this.IsFirstShow()) {
            this._parrot.ToggleBubble();
        }
    }

    @Override
    public void update(float f) {
        super.update(f);
        this.hideEnterNameBoxes.Update(f);
        this.hideEnterNameLbls.Update(f);
        this.showDetectorLocs.Update(f);
    }

    @Override
    public void render() {
        if (this.imgBack != null) {
            this._app.image(this.imgBack, 0.0f, 0.0f);
        }
    }

    private class NextButtonClick
    implements ButtonElement.IButtonCallback {
        private NextButtonClick() {
        }

        @Override
        public void OnClicked(ButtonElement buttonElement, int n) {
            if (!EnterNamePage.this._enteredNamed && buttonElement == EnterNamePage.this.btnNext) {
                if (EnterNamePage.this.txtDetectorName.getText().trim() == "") {
                    EnterNamePage.this._parrot.ShowExtraBubble(Language.getString("EnterNamePage_parrot_3"), 300, 50, true);
                    return;
                }
                if (EnterNamePage.this.txtPlayerName.getText().trim() == "") {
                    EnterNamePage.this._parrot.ShowExtraBubble(Language.getString("EnterNamePage_parrot_4"), 300, 50, true);
                    return;
                }
                PlayerData.PlayerName = EnterNamePage.this.txtPlayerName.getText();
                PlayerData.DetectorName = EnterNamePage.this.txtDetectorName.getText();
                EnterNamePage.this._enteredNamed = true;
                EnterNamePage.this.hideEnterNameBoxes.Start();
                EnterNamePage.this.hideEnterNameLbls.Start();
            } else if (EnterNamePage.this._enteredNamed && !EnterNamePage.this.hideEnterNameBoxes.isRunning()) {
                GameScreen.showPage("PIOffice");
            }
        }
    }

    private class HideEnterDetails
    implements IAnimationCompleteCallback {
        private HideEnterDetails() {
        }

        @Override
        public void OnComplete(KeyFrameAnimation keyFrameAnimation) {
            EnterNamePage.this._map.setVisible(true);
            EnterNamePage.this._locFrm.setVisible(true);
            EnterNamePage.this._pageTitle.setVisible(true);
            EnterNamePage.this.showDetectorLocs.Start();
            EnterNamePage.this._parrot.ShowExtraBubble(Language.getString("EnterNamePage_parrot_2"), 300, 150, true);
        }
    }
}

